/*
 * Decompiled with CFR 0.152.
 */
package patinapipeworks.block;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import patinapipeworks.api.PPBlocks;
import patinapipeworks.api.PPSounds;
import patinapipeworks.block.WeatheringCopperPP;
import patinapipeworks.init.ModTags;
import patinapipeworks.tileentity.CopperPipeBlockEntity;

public class CopperPipeBlock
extends PipeBlock
implements WeatheringCopperPP,
EntityBlock,
SimpleWaterloggedBlock {
    private final WeatheringCopper.WeatherState weatherState;
    private static final int MAX_STRENGTH = 15;
    public static final IntegerProperty STRENGTH = IntegerProperty.m_61631_((String)"strength", (int)0, (int)15);
    public static final BooleanProperty OPENED = BooleanProperty.m_61465_((String)"opened");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public CopperPipeBlock(WeatheringCopper.WeatherState p_154925_, BlockBehaviour.Properties builder) {
        super(0.125f, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(false)));
        this.weatherState = p_154925_;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        boolean flag = world.m_6425_(blockpos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)this.makeConnections((BlockGetter)context.m_43725_(), this.m_49966_(), blockpos).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack handItem = player.m_21120_(handIn);
        if (handItem.m_41720_() == Items.f_42784_ || handItem.m_41720_() instanceof AxeItem) {
            return WeatheringCopperPP.honeycombAndAxeInteraction(state, worldIn, pos, player, handIn, hit);
        }
        if (!handItem.m_150922_(ModTags.Items.copper_pipe_attachable) && CopperPipeBlock.isEndPipe(state)) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            state = (BlockState)state.m_61122_((Property)OPENED);
            worldIn.m_7731_(pos, state, 3);
            BlockState blockstate = state;
            SoundEvent sound = (Boolean)blockstate.m_61143_((Property)OPENED) != false ? PPSounds.VALVE_TURN : PPSounds.VALVE_TURN_OFF;
            worldIn.m_5594_((Player)null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f + worldIn.m_5822_().nextFloat() * 0.5f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private int calculateTargetStrength(Level world, BlockPos pos) {
        return Math.max(0, this.getBestNeighborStrength(world, pos) - 1);
    }

    private void updateStrength(Level world, BlockPos pos, BlockState state) {
        int i = this.calculateTargetStrength(world, pos);
        if ((Integer)state.m_61143_((Property)STRENGTH) != i) {
            if (world.m_8055_(pos) == state) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)STRENGTH, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet neighborsToUpdate = Sets.newHashSet();
            neighborsToUpdate.add(pos);
            for (Direction direction : Direction.values()) {
                neighborsToUpdate.add(pos.m_142300_(direction));
            }
            for (BlockPos blockpos : neighborsToUpdate) {
                world.m_46672_(blockpos, (Block)this);
            }
        }
    }

    private int getBestNeighborStrength(Level world, BlockPos pos) {
        int bestStrength = 0;
        for (Direction direction : Direction.values()) {
            int strength = this.getStrength(world, pos, direction);
            if (strength >= 15) {
                return 15;
            }
            if (strength <= bestStrength) continue;
            bestStrength = strength;
        }
        return bestStrength;
    }

    private int getStrength(Level world, BlockPos pos, Direction direction) {
        BlockState state = world.m_8055_(pos.m_142300_(direction));
        if (state.m_60620_(ModTags.Blocks.copper_pipe_bases) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)).booleanValue() && world.m_46681_(pos.m_142300_(direction), direction) > 0) {
            return 15;
        }
        return state.m_60620_(ModTags.Blocks.copper_pipes) ? (Integer)state.m_61143_((Property)STRENGTH) : 0;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!oldState.m_60713_(state.m_60734_()) && !world.f_46443_) {
            this.updateStrength(world, pos, state);
            this.updateNeighborsOfNeighboringPipes(world, pos);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify) {
        if (!notify && !state.m_60713_(oldState.m_60734_())) {
            super.m_6810_(state, world, pos, oldState, notify);
            if (!world.f_46443_) {
                for (Direction direction : Direction.values()) {
                    world.m_46672_(pos.m_142300_(direction), (Block)this);
                }
                this.updateStrength(world, pos, state);
                this.updateNeighborsOfNeighboringPipes(world, pos);
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean notify) {
        if (!world.f_46443_) {
            if (state.m_60710_((LevelReader)world, pos)) {
                this.updateStrength(world, pos, state);
            } else {
                CopperPipeBlock.m_49950_((BlockState)state, (Level)world, (BlockPos)pos);
                world.m_7471_(pos, false);
            }
        }
    }

    private void updateNeighborsOfNeighboringPipes(Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_142300_(direction);
            if (!world.m_8055_(neighborPos).m_60713_((Block)this)) continue;
            world.m_46672_(neighborPos, (Block)this);
            for (Direction direction2 : Direction.values()) {
                world.m_46672_(neighborPos.m_142300_(direction2), (Block)this);
            }
        }
    }

    public BlockState makeConnections(BlockGetter reader, BlockState state, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!reader.m_8055_(pos.m_142300_(direction)).m_60620_(ModTags.Blocks.copper_pipe_attachable)) continue;
            state = (BlockState)state.m_61124_((Property)f_55154_.get(direction), (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isEndPipe(BlockState stateIn) {
        int ends = 0;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)stateIn.m_61143_((Property)f_55154_.get(direction))).booleanValue()) continue;
            ++ends;
        }
        return ends == 1;
    }

    @Nullable
    public static Direction endPipeDirection(BlockState stateIn) {
        if (CopperPipeBlock.isEndPipe(stateIn)) {
            for (Direction direction : Direction.values()) {
                if (!((Boolean)stateIn.m_61143_((Property)f_55154_.get(direction))).booleanValue()) continue;
                return direction;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (CopperPipeBlock.isEndPipe(stateIn) && ((Boolean)stateIn.m_61143_((Property)OPENED)).booleanValue() && (Integer)stateIn.m_61143_((Property)STRENGTH) > 0) {
            if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                if (rand.nextInt(32) == 0) {
                    worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11774_, SoundSource.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
                }
            } else if (rand.nextInt(16) == 0) {
                worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12540_, SoundSource.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        boolean flag = facingState.m_60620_(ModTags.Blocks.copper_pipe_attachable);
        stateIn = (BlockState)stateIn.m_61124_((Property)f_55154_.get(facing), (Comparable)Boolean.valueOf(flag));
        boolean openedFlag = (Boolean)stateIn.m_61143_((Property)OPENED);
        if (!CopperPipeBlock.isEndPipe(stateIn)) {
            openedFlag = false;
        }
        return (BlockState)stateIn.m_61124_((Property)OPENED, (Comparable)Boolean.valueOf(openedFlag));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STRENGTH, OPENED, WATERLOGGED, f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CopperPipeBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152755_, BlockState p_152756_, BlockEntityType<T> p_152757_) {
        if (p_152755_.f_46443_) {
            return (Boolean)p_152756_.m_61143_((Property)OPENED) != false && (Integer)p_152756_.m_61143_((Property)STRENGTH) > 0 ? CopperPipeBlock.createTickerHelper(p_152757_, PPBlocks.COPPER_PIPE_BLOCK_ENTITY, CopperPipeBlockEntity::clientTick) : null;
        }
        return CopperPipeBlock.createTickerHelper(p_152757_, PPBlocks.COPPER_PIPE_BLOCK_ENTITY, CopperPipeBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    public static void makeParticles(ParticleOptions particle, Level worldIn, BlockPos pos, BlockState stateIn, Random rand) {
        if (CopperPipeBlock.isEndPipe(stateIn) && CopperPipeBlock.endPipeDirection(stateIn) != null) {
            double particle_x = -((double)CopperPipeBlock.endPipeDirection(stateIn).m_122429_() * 0.15) + (rand.nextDouble() - rand.nextDouble()) / 9.0;
            double particle_y = -((double)CopperPipeBlock.endPipeDirection(stateIn).m_122430_() * 0.15) + (rand.nextDouble() - rand.nextDouble()) / 9.0;
            double particle_z = -((double)CopperPipeBlock.endPipeDirection(stateIn).m_122431_() * 0.15) + (rand.nextDouble() - rand.nextDouble()) / 9.0;
            worldIn.m_7107_(particle, (double)pos.m_123341_() + 0.5 + particle_x, (double)pos.m_123342_() + 0.4375 + particle_y, (double)pos.m_123343_() + 0.5 + particle_z, particle_x * 2.0, particle_y * 2.0, particle_z * 2.0);
        }
    }

    public void m_7455_(BlockState p_154929_, ServerLevel p_154930_, BlockPos p_154931_, Random p_154932_) {
        this.m_153041_(p_154929_, p_154930_, p_154931_, p_154932_);
    }

    public boolean m_6724_(BlockState p_154935_) {
        return WeatheringCopperPP.getNext(p_154935_.m_60734_()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

