/*
 * Decompiled with CFR 0.152.
 */
package patinapipeworks.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import patinapipeworks.api.PPSounds;
import patinapipeworks.block.WeatheringCopperPP;
import patinapipeworks.init.ModTags;

public class CopperPipeValveBlock
extends Block
implements WeatheringCopperPP,
SimpleWaterloggedBlock {
    private final WeatheringCopper.WeatherState weatherState;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)5);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape NORTH = Block.m_49796_((double)1.0, (double)1.0, (double)10.0, (double)15.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)6.0);
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)15.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)10.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    protected static final VoxelShape UP = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0);
    protected static final VoxelShape DOWN = Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public CopperPipeValveBlock(WeatheringCopper.WeatherState p_154925_, BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
        this.weatherState = p_154925_;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case SOUTH: {
                return SOUTH;
            }
        }
        return NORTH;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return CopperPipeValveBlock.canAttach(world, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    public static boolean canAttach(LevelReader p_220185_0_, BlockPos p_220185_1_, Direction p_220185_2_) {
        BlockPos blockpos = p_220185_1_.m_142300_(p_220185_2_);
        return p_220185_0_.m_8055_(blockpos).m_60620_(ModTags.Blocks.copper_pipe_bases);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        boolean flag = world.m_6425_(blockpos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack handItem = player.m_21120_(handIn);
        if (handItem.m_41720_() == Items.f_42784_ || handItem.m_41720_() instanceof AxeItem) {
            return WeatheringCopperPP.honeycombAndAxeInteraction(state, worldIn, pos, player, handIn, hit);
        }
        if (!handItem.m_150922_(ModTags.Items.copper_pipe_attachable)) {
            if (worldIn.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int rot = (Integer)state.m_61143_((Property)ROTATION);
            rot = player.m_6047_() ? (rot > 0 ? --rot : 5) : (rot < 5 ? ++rot : 0);
            state = (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot));
            worldIn.m_7731_(pos, state, 3);
            this.updateNeighbours(state, worldIn, pos);
            SoundEvent sound = (Integer)state.m_61143_((Property)ROTATION) == 0 ? PPSounds.VALVE_TURN_OFF : PPSounds.VALVE_TURN;
            worldIn.m_5594_((Player)null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f + worldIn.m_5822_().nextFloat() * 0.5f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private void updateNeighbours(BlockState state, Level world, BlockPos pos) {
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_()), (Block)this);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, state2, world, pos, pos2);
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.m_60717_(p_185471_2_.m_54846_((Direction)p_185471_1_.m_61143_((Property)FACING)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ROTATION, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_7455_(BlockState p_154929_, ServerLevel p_154930_, BlockPos p_154931_, Random p_154932_) {
        this.m_153041_(p_154929_, p_154930_, p_154931_, p_154932_);
    }

    public boolean m_6724_(BlockState p_154935_) {
        return WeatheringCopperPP.getNext(p_154935_.m_60734_()).isPresent();
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

