/*
 * Decompiled with CFR 0.152.
 */
package patinapipeworks.block;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import patinapipeworks.api.PPBlocks;
import patinapipeworks.init.ModVanillaCompat;

public interface WeatheringCopperPP
extends WeatheringCopper {
    public static final Supplier<BiMap<Block, Block>> NEXT_BY_BLOCK = Suppliers.memoize(() -> ImmutableBiMap.builder().put((Object)PPBlocks.COPPER_PIPE, (Object)PPBlocks.EXPOSED_COPPER_PIPE).put((Object)PPBlocks.EXPOSED_COPPER_PIPE, (Object)PPBlocks.WEATHERED_COPPER_PIPE).put((Object)PPBlocks.WEATHERED_COPPER_PIPE, (Object)PPBlocks.OXIDIZED_COPPER_PIPE).put((Object)PPBlocks.COPPER_PIPE_BASE, (Object)PPBlocks.EXPOSED_COPPER_PIPE_BASE).put((Object)PPBlocks.EXPOSED_COPPER_PIPE_BASE, (Object)PPBlocks.WEATHERED_COPPER_PIPE_BASE).put((Object)PPBlocks.WEATHERED_COPPER_PIPE_BASE, (Object)PPBlocks.OXIDIZED_COPPER_PIPE_BASE).put((Object)PPBlocks.COPPER_PIPE_VALVE, (Object)PPBlocks.EXPOSED_COPPER_PIPE_VALVE).put((Object)PPBlocks.EXPOSED_COPPER_PIPE_VALVE, (Object)PPBlocks.WEATHERED_COPPER_PIPE_VALVE).put((Object)PPBlocks.WEATHERED_COPPER_PIPE_VALVE, (Object)PPBlocks.OXIDIZED_COPPER_PIPE_VALVE).build());
    public static final Supplier<BiMap<Block, Block>> PREVIOUS_BY_BLOCK = Suppliers.memoize(() -> NEXT_BY_BLOCK.get().inverse());

    public static Optional<Block> getNext(Block p_154905_) {
        return Optional.ofNullable((Block)NEXT_BY_BLOCK.get().get((Object)p_154905_));
    }

    default public Optional<BlockState> m_142123_(BlockState p_154893_) {
        return WeatheringCopperPP.getNext(p_154893_.m_60734_()).map(p_154896_ -> p_154896_.m_152465_(p_154893_));
    }

    public static Optional<Block> getPrevious(Block p_154891_) {
        return Optional.ofNullable((Block)PREVIOUS_BY_BLOCK.get().get((Object)p_154891_));
    }

    public static Optional<BlockState> getPrevious(BlockState p_154900_) {
        return WeatheringCopperPP.getPrevious(p_154900_.m_60734_()).map(p_154903_ -> p_154903_.m_152465_(p_154900_));
    }

    public static InteractionResult honeycombAndAxeInteraction(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item handItem = player.m_21120_(handIn).m_41720_();
        if (handItem == Items.f_42784_) {
            BlockState blockstate = worldIn.m_8055_(pos);
            return ModVanillaCompat.getWaxed(blockstate).map(p_150874_ -> {
                ItemStack itemstack = player.m_21120_(handIn);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, itemstack);
                }
                itemstack.m_41774_(1);
                worldIn.m_7731_(pos, p_150874_, 11);
                worldIn.m_5898_(player, 3003, pos, 0);
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }).orElse(InteractionResult.PASS);
        }
        if (handItem instanceof AxeItem) {
            BlockState blockstate = worldIn.m_8055_(pos);
            Optional<BlockState> optional1 = Optional.ofNullable(WeatheringCopperPP.getPrevious(state).orElse(null));
            Optional<BlockState> optional2 = Optional.ofNullable(Optional.ofNullable((Block)ModVanillaCompat.WAX_OFF_BY_BLOCK.get().get((Object)state.m_60734_())).map(p_150694_ -> p_150694_.m_152465_(blockstate)).orElse(null));
            ItemStack itemstack = player.m_21120_(handIn);
            Optional<Object> optional3 = Optional.empty();
            if (optional1.isPresent()) {
                worldIn.m_5594_(player, pos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_5898_(player, 3005, pos, 0);
                optional3 = optional1;
            } else if (optional2.isPresent()) {
                worldIn.m_5594_(player, pos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.m_5898_(player, 3004, pos, 0);
                optional3 = optional2;
            }
            if (optional3.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_45482_((ServerPlayer)player, pos, itemstack);
                }
                worldIn.m_7731_(pos, (BlockState)optional3.get(), 11);
                if (player != null) {
                    itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(handIn));
                }
                return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.FAIL;
    }
}

