/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HitBoxData {
    public static Map<Direction, VoxelShape> build(double[][] cordsets, boolean orientedDown) {
        HashMap<Direction, VoxelShape> voxelShapeMap = new HashMap<Direction, VoxelShape>();
        HashMap<Direction, List> shapeMap = new HashMap<Direction, List>();
        for (double[] cords : cordsets) {
            if (cords.length != 6) continue;
            Map<Direction, VoxelShape> values = HitBoxData.getValues(orientedDown, cords);
            for (Map.Entry<Direction, VoxelShape> value : values.entrySet()) {
                List shapeList = shapeMap.getOrDefault(value.getKey(), new ArrayList());
                shapeList.add(value.getValue());
                shapeMap.put(value.getKey(), shapeList);
            }
        }
        Object object = shapeMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry shapeEntry = (Map.Entry)object.next();
            List shapeList = (List)shapeEntry.getValue();
            VoxelShape[] voxels = new VoxelShape[shapeList.size() - 1];
            for (int index = 0; index < voxels.length; ++index) {
                voxels[index] = (VoxelShape)shapeList.get(index + 1);
            }
            VoxelShape voxelShape = Shapes.m_83124_((VoxelShape)((VoxelShape)shapeList.get(0)), (VoxelShape[])voxels);
            voxelShapeMap.put((Direction)shapeEntry.getKey(), voxelShape);
        }
        return voxelShapeMap;
    }

    private static Map<Direction, VoxelShape> getValues(boolean orientedDown, double ... cords) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        if (orientedDown) {
            map.put(Direction.DOWN, HitBoxData.createShape(cords[0], cords[1], cords[2], cords[3], cords[4], cords[5]));
            map.put(Direction.UP, HitBoxData.createShape(cords[0], 16.0 - cords[4], 16.0 - cords[5], cords[3], 16.0 - cords[1], 16.0 - cords[2]));
            cords = new double[]{cords[0], 16.0 - cords[5], cords[1], cords[3], 16.0 - cords[2], cords[4]};
        } else {
            map.put(Direction.DOWN, HitBoxData.createShape(cords[0], cords[2], 16.0 - cords[4], cords[3], cords[5], 16.0 - cords[1]));
            map.put(Direction.UP, HitBoxData.createShape(cords[0], 16.0 - cords[5], cords[1], cords[3], 16.0 - cords[2], cords[4]));
        }
        map.put(Direction.NORTH, HitBoxData.createShape(cords[0], cords[1], cords[2], cords[3], cords[4], cords[5]));
        map.put(Direction.SOUTH, HitBoxData.createShape(16.0 - cords[3], cords[1], 16.0 - cords[5], 16.0 - cords[0], cords[4], 16.0 - cords[2]));
        map.put(Direction.WEST, HitBoxData.createShape(cords[5], cords[1], 16.0 - cords[0], cords[2], cords[4], 16.0 - cords[3]));
        map.put(Direction.EAST, HitBoxData.createShape(16.0 - cords[2], cords[1], cords[0], 16.0 - cords[5], cords[4], cords[3]));
        return map;
    }

    public static VoxelShape createShape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.m_49796_((double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
    }
}

