/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.apache.logging.log4j.Logger;

public class NBTFile {
    public static void write(@Nonnull CompoundTag nbtData, @Nonnull File saveFile, @Nonnull Logger log) {
        try {
            NBTFile.write(nbtData, saveFile);
        }
        catch (IOException error) {
            log.error("Failed to write file " + saveFile.getName() + " ; " + error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(@Nonnull CompoundTag nbtData, @Nonnull File saveFile) throws IOException {
        File tempFile = new File(saveFile.getAbsolutePath() + "_tmp");
        if (tempFile.exists()) {
            tempFile.delete();
        }
        try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(tempFile));){
            NbtIo.m_128947_((CompoundTag)nbtData, (OutputStream)dataoutputstream);
        }
        if (saveFile.exists()) {
            saveFile.delete();
        }
        if (saveFile.exists()) {
            throw new IOException("Failed to delete " + saveFile);
        }
        tempFile.renameTo(saveFile);
    }

    public static CompoundTag read(@Nonnull File saveFile, @Nonnull Logger log) {
        CompoundTag nbtData = new CompoundTag();
        try {
            nbtData = NBTFile.read(saveFile);
        }
        catch (IOException error) {
            log.error("Failed to read file " + saveFile.getName() + " ; " + error);
        }
        return nbtData;
    }

    private static CompoundTag read(@Nonnull File saveFile) throws IOException {
        if (!saveFile.exists()) {
            throw new FileNotFoundException();
        }
        return NbtIo.m_128939_((InputStream)new DataInputStream(new FileInputStream(saveFile)));
    }
}

