/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private awt entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<gh> setLitChunkPos = new HashSet();
    private gh.a blockPosMutable = new gh.a();

    public DynamicLight(awt entity) {
        this.entity = entity;
        this.offsetY = entity.cy();
    }

    public void update(epj renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dc() - 0.5;
        double posY = this.entity.de() - 0.5 + this.offsetY;
        double posZ = this.entity.di() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((awt)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            gm dirX = (aiy.b((double)posX) & 0xF) >= 8 ? gm.f : gm.e;
            gm dirY = (aiy.b((double)posY) & 0xF) >= 8 ? gm.b : gm.a;
            gm dirZ = (aiy.b((double)posZ) & 0xF) >= 8 ? gm.d : gm.c;
            gh chunkPos = new gh(posX, posY, posZ);
            esa.c chunk = renderGlobal.getRenderChunk(chunkPos);
            gh chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            esa.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            gh chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            esa.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            gh chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            esa.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            gh chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            esa.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            gh chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            esa.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            gh chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            esa.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            gh chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            esa.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private gh getChunkPos(esa.c renderChunk, gh pos, gm facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(esa.c renderChunk, Set<gh> setPrevPos, Set<gh> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        esa.b compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        gh pos = renderChunk.e().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(epj renderGlobal) {
        for (gh posOld : this.setLitChunkPos) {
            esa.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public awt getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

