/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.Properties;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntities;
import net.optifine.RandomEntity;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeInt;
import net.optifine.config.RangeListInt;
import net.optifine.config.Weather;
import net.optifine.util.ArrayUtils;
import net.optifine.util.MathUtils;

public class RandomEntityRule {
    private String pathProps = null;
    private yh baseResLoc = null;
    private int index;
    private int[] textures = null;
    private yh[] resourceLocations = null;
    private int[] weights = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private RangeListInt healthRange = null;
    private boolean healthPercent = false;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private MatchProfession[] professions = null;
    private bta[] collarColors = null;
    private Boolean baby = null;
    private RangeListInt moonPhases = null;
    private RangeListInt dayTimes = null;
    private Weather[] weatherList = null;

    public RandomEntityRule(Properties props, String pathProps, yh baseResLoc, int index, String valTextures, ConnectedParser cp) {
        String healthStr;
        this.pathProps = pathProps;
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.textures = cp.parseIntList(valTextures);
        this.weights = cp.parseIntList(props.getProperty("weights." + index));
        this.biomes = cp.parseBiomes(props.getProperty("biomes." + index));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights." + index));
        if (this.heights == null) {
            this.heights = this.parseMinMaxHeight(props, index);
        }
        if ((healthStr = props.getProperty("health." + index)) != null) {
            this.healthPercent = healthStr.contains("%");
            healthStr = healthStr.replace("%", "");
            this.healthRange = cp.parseRangeListInt(healthStr);
        }
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name." + index));
        this.professions = cp.parseProfessions(props.getProperty("professions." + index));
        this.collarColors = cp.parseDyeColors(props.getProperty("collarColors." + index), "collar color", ConnectedParser.DYE_COLORS_INVALID);
        this.baby = cp.parseBooleanObject(props.getProperty("baby." + index));
        this.moonPhases = cp.parseRangeListInt(props.getProperty("moonPhase." + index));
        this.dayTimes = cp.parseRangeListInt(props.getProperty("dayTime." + index));
        this.weatherList = cp.parseWeather(props.getProperty("weather." + index), "weather." + index, null);
    }

    private RangeListInt parseMinMaxHeight(Properties props, int index) {
        String minHeightStr = props.getProperty("minHeight." + index);
        String maxHeightStr = props.getProperty("maxHeight." + index);
        if (minHeightStr == null && maxHeightStr == null) {
            return null;
        }
        int minHeight = 0;
        if (minHeightStr != null && (minHeight = Config.parseInt((String)minHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid minHeight: " + minHeightStr));
            return null;
        }
        int maxHeight = 256;
        if (maxHeightStr != null && (maxHeight = Config.parseInt((String)maxHeightStr, (int)-1)) < 0) {
            Config.warn((String)("Invalid maxHeight: " + maxHeightStr));
            return null;
        }
        if (maxHeight < 0) {
            Config.warn((String)("Invalid minHeight, maxHeight: " + minHeightStr + ", " + maxHeightStr));
            return null;
        }
        RangeListInt list = new RangeListInt();
        list.addRange(new RangeInt(minHeight, maxHeight));
        return list;
    }

    public boolean isValid(String path) {
        if (this.textures == null || this.textures.length == 0) {
            Config.warn((String)("Invalid skins for rule: " + this.index));
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new yh[this.textures.length];
        boolean optifine = this.pathProps.startsWith("optifine/mob/");
        yh locOf = RandomEntities.getLocationRandom((yh)this.baseResLoc, (boolean)optifine);
        if (locOf == null) {
            Config.warn((String)("Invalid path: " + this.baseResLoc.a()));
            return false;
        }
        for (int i2 = 0; i2 < this.resourceLocations.length; ++i2) {
            int index = this.textures[i2];
            if (index <= 1) {
                this.resourceLocations[i2] = this.baseResLoc;
                continue;
            }
            yh locNew = RandomEntities.getLocationIndexed((yh)locOf, (int)index);
            if (locNew == null) {
                Config.warn((String)("Invalid path: " + this.baseResLoc.a()));
                return false;
            }
            if (!Config.hasResource((yh)locNew)) {
                Config.warn((String)("Texture not found: " + locNew.a()));
                return false;
            }
            this.resourceLocations[i2] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn((String)("More weights defined than skins, trimming weights: " + path));
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn((String)("Less weights defined than skins, expanding weights: " + path));
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage((int[])this.weights);
                for (int i3 = this.weights.length; i3 < weights2.length; ++i3) {
                    weights2[i3] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i4 = 0; i4 < this.weights.length; ++i4) {
                if (this.weights[i4] < 0) {
                    Config.warn((String)("Invalid weight: " + this.weights[i4]));
                    return false;
                }
                this.sumWeights[i4] = sum += this.weights[i4];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn((String)("Invalid sum of all weights: " + sum));
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.collarColors == ConnectedParser.DYE_COLORS_INVALID) {
            Config.warn((String)("Invalid collar colors: " + path));
            return false;
        }
        return true;
    }

    public boolean matches(IRandomEntity randomEntity) {
        Weather weather;
        int dayTime;
        int moonPhase;
        ell world;
        axh livingEntity;
        awt entity;
        int level;
        bne entityVillager;
        bnf vd;
        bnh vp;
        RandomEntity rme;
        awt entity2;
        String name;
        gh pos;
        if (this.biomes != null && !Matches.biome((caz)randomEntity.getSpawnBiome(), (BiomeId[])this.biomes)) {
            return false;
        }
        if (this.heights != null && (pos = randomEntity.getSpawnPosition()) != null && !this.heights.isInRange(pos.v())) {
            return false;
        }
        if (this.healthRange != null) {
            int healthMax;
            int health = randomEntity.getHealth();
            if (this.healthPercent && (healthMax = randomEntity.getMaxHealth()) > 0) {
                health = (int)((double)(health * 100) / (double)healthMax);
            }
            if (!this.healthRange.isInRange(health)) {
                return false;
            }
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = randomEntity.getName())) {
            return false;
        }
        if (this.professions != null && randomEntity instanceof RandomEntity && (entity2 = (rme = (RandomEntity)randomEntity).getEntity()) instanceof bne && !MatchProfession.matchesOne((bnh)(vp = (vd = (entityVillager = (bne)entity2).fJ()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions)) {
            return false;
        }
        if (this.collarColors != null && randomEntity instanceof RandomEntity) {
            bta col;
            rme = (RandomEntity)randomEntity;
            awt entity3 = rme.getEntity();
            if (entity3 instanceof bim) {
                bim entityWolf = (bim)entity3;
                if (!entityWolf.q()) {
                    return false;
                }
                col = entityWolf.fJ();
                if (!Config.equalsOne((Object)col, (Object[])this.collarColors)) {
                    return false;
                }
            }
            if (entity3 instanceof bho) {
                bho entityCat = (bho)entity3;
                if (!entityCat.q()) {
                    return false;
                }
                col = entityCat.fK();
                if (!Config.equalsOne((Object)col, (Object[])this.collarColors)) {
                    return false;
                }
            }
        }
        if (this.baby != null && randomEntity instanceof RandomEntity && (entity = (rme = (RandomEntity)randomEntity).getEntity()) instanceof axh && (livingEntity = (axh)entity).y_() != this.baby.booleanValue()) {
            return false;
        }
        if (this.moonPhases != null && (world = Config.getMinecraft().r) != null && !this.moonPhases.isInRange(moonPhase = world.al())) {
            return false;
        }
        if (this.dayTimes != null && (world = Config.getMinecraft().r) != null && !this.dayTimes.isInRange(dayTime = (int)world.W())) {
            return false;
        }
        return this.weatherList == null || (world = Config.getMinecraft().r) == null || ArrayUtils.contains((Object[])this.weatherList, (Object)(weather = Weather.getWeather((cad)world, (float)0.0f)));
    }

    public yh getTextureLocation(yh loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i2 = 0; i2 < this.sumWeights.length; ++i2) {
                if (this.sumWeights[i2] <= randWeight) continue;
                index = i2;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

