/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import net.optifine.Config;

public class MatchProfession {
    private bnh profession;
    private int[] levels;

    public MatchProfession(bnh profession) {
        this(profession, null);
    }

    public MatchProfession(bnh profession, int level) {
        this(profession, new int[]{level});
    }

    public MatchProfession(bnh profession, int[] levels) {
        this.profession = profession;
        this.levels = levels;
    }

    public boolean matches(bnh prof, int lev) {
        if (this.profession != prof) {
            return false;
        }
        return this.levels == null || Config.equalsOne((int)lev, (int[])this.levels);
    }

    private boolean hasLevel(int lev) {
        if (this.levels == null) {
            return false;
        }
        return Config.equalsOne((int)lev, (int[])this.levels);
    }

    public boolean addLevel(int lev) {
        if (this.levels == null) {
            this.levels = new int[]{lev};
            return true;
        }
        if (this.hasLevel(lev)) {
            return false;
        }
        this.levels = Config.addIntToArray((int[])this.levels, (int)lev);
        return true;
    }

    public bnh getProfession() {
        return this.profession;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public static boolean matchesOne(bnh prof, int level, MatchProfession[] mps) {
        if (mps == null) {
            return false;
        }
        for (int i2 = 0; i2 < mps.length; ++i2) {
            MatchProfession mp = mps[i2];
            if (!mp.matches(prof, level)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.levels == null) {
            return "" + this.profession;
        }
        return this.profession + ":" + Config.arrayToString((int[])this.levels);
    }
}

