/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.refinedmods.refinedstorage.api.render.IElementDrawers;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.render.Styles;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ErrorCraftingMonitorElement
implements ICraftingMonitorElement {
    public static final ResourceLocation ID = new ResourceLocation("error");
    private final ICraftingMonitorElement base;
    private final String message;

    public ErrorCraftingMonitorElement(ICraftingMonitorElement base, String message) {
        this.base = base;
        this.message = message;
    }

    public static ErrorCraftingMonitorElement read(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        String message = PacketBufferUtils.readString(buf);
        return new ErrorCraftingMonitorElement(API.instance().getCraftingMonitorElementRegistry().get(id).apply(buf), message);
    }

    @Override
    public void draw(PoseStack poseStack, int x, int y, IElementDrawers drawers) {
        this.base.draw(poseStack, x, y, drawers);
        drawers.getErrorDrawer().draw(poseStack, x, y, null);
    }

    @Override
    @Nullable
    public List<Component> getTooltip() {
        ArrayList<Component> items = new ArrayList<Component>(this.base.getTooltip());
        items.add((Component)new TranslatableComponent(this.message).m_6270_(Styles.RED));
        return items;
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public ResourceLocation getBaseId() {
        return this.base.getId();
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.base.getId());
        buf.m_130070_(this.message);
        this.base.write(buf);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        return this.elementHashCode() == element.elementHashCode() && this.base.merge(((ErrorCraftingMonitorElement)element).base);
    }

    @Override
    public int baseElementHashCode() {
        return this.base.elementHashCode();
    }

    @Override
    public int elementHashCode() {
        return this.base.elementHashCode() ^ this.message.hashCode();
    }

    public void mergeBases(ICraftingMonitorElement element) {
        this.base.merge(element);
    }
}

