/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferCraftingGridError;
import com.refinedmods.refinedstorage.integration.jei.RecipeTransferPatternGridError;
import com.refinedmods.refinedstorage.network.grid.GridCraftingPreviewRequestMessage;
import com.refinedmods.refinedstorage.network.grid.GridProcessingTransferMessage;
import com.refinedmods.refinedstorage.network.grid.GridTransferMessage;
import com.refinedmods.refinedstorage.screen.grid.GridScreen;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraftforge.fluids.FluidStack;

public class GridRecipeTransferHandler
implements IRecipeTransferHandler<GridContainerMenu, Object> {
    public static final GridRecipeTransferHandler INSTANCE = new GridRecipeTransferHandler();
    private static final long TRANSFER_SCROLLBAR_DELAY_MS = 200L;
    private long lastTransferTimeMs;

    private GridRecipeTransferHandler() {
    }

    public Class<GridContainerMenu> getContainerClass() {
        return GridContainerMenu.class;
    }

    public Class<Object> getRecipeClass() {
        return Object.class;
    }

    public IRecipeTransferError transferRecipe(@Nonnull GridContainerMenu container, Object recipe, @Nonnull IRecipeLayout recipeLayout, @Nonnull Player player, boolean maxTransfer, boolean doTransfer) {
        if (!(container.getScreenInfoProvider() instanceof GridScreen)) {
            return null;
        }
        GridType type = container.getGrid().getGridType();
        if (type == GridType.CRAFTING) {
            return this.transferRecipeForCraftingGrid(container, recipe, recipeLayout, player, doTransfer);
        }
        if (type == GridType.PATTERN) {
            return this.transferRecipeForPatternGrid(container, recipe, recipeLayout, player, doTransfer);
        }
        return null;
    }

    private RecipeTransferCraftingGridError transferRecipeForCraftingGrid(GridContainerMenu container, Object recipe, IRecipeLayout recipeLayout, Player player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            if (tracker.hasMissingButAutocraftingAvailable() && Screen.m_96637_()) {
                tracker.createCraftingRequests().forEach((id, count) -> RS.NETWORK_HANDLER.sendToServer(new GridCraftingPreviewRequestMessage((UUID)id, (int)count, Screen.m_96638_(), false)));
            } else {
                this.moveItems(container, recipe, recipeLayout, tracker);
            }
        } else if (tracker.hasMissing()) {
            return new RecipeTransferCraftingGridError(tracker);
        }
        return null;
    }

    private IRecipeTransferError transferRecipeForPatternGrid(GridContainerMenu container, Object recipe, IRecipeLayout recipeLayout, Player player, boolean doTransfer) {
        IngredientTracker tracker = this.createTracker(container, recipeLayout, player, doTransfer);
        if (doTransfer) {
            this.moveItems(container, recipe, recipeLayout, tracker);
        } else if (tracker.isAutocraftingAvailable()) {
            return new RecipeTransferPatternGridError(tracker);
        }
        return null;
    }

    private IngredientTracker createTracker(GridContainerMenu container, IRecipeLayout recipeLayout, Player player, boolean doTransfer) {
        CraftingContainer craftingMatrix;
        IngredientTracker tracker = new IngredientTracker(recipeLayout, doTransfer);
        Collection<IGridStack> gridStacks = ((GridScreen)container.getScreenInfoProvider()).getView().getAllStacks();
        if (container.getGrid().isGridActive()) {
            for (IGridStack gridStack : gridStacks) {
                if (!(gridStack instanceof ItemGridStack)) continue;
                tracker.addAvailableStack(((ItemGridStack)gridStack).getStack(), gridStack);
            }
        }
        for (int inventorySlot = 0; inventorySlot < player.m_150109_().m_6643_(); ++inventorySlot) {
            if (player.m_150109_().m_8020_(inventorySlot).m_41619_()) continue;
            tracker.addAvailableStack(player.m_150109_().m_8020_(inventorySlot), null);
        }
        if (container.getGrid().getGridType().equals((Object)GridType.CRAFTING) && (craftingMatrix = container.getGrid().getCraftingMatrix()) != null) {
            for (int matrixSlot = 0; matrixSlot < craftingMatrix.m_6643_(); ++matrixSlot) {
                if (craftingMatrix.m_8020_(matrixSlot).m_41619_()) continue;
                tracker.addAvailableStack(craftingMatrix.m_8020_(matrixSlot), null);
            }
        }
        return tracker;
    }

    public boolean hasTransferredRecently() {
        return System.currentTimeMillis() - this.lastTransferTimeMs <= 200L;
    }

    private void moveItems(GridContainerMenu gridContainer, Object recipe, IRecipeLayout recipeLayout, IngredientTracker tracker) {
        this.lastTransferTimeMs = System.currentTimeMillis();
        if (gridContainer.getGrid().getGridType() == GridType.PATTERN && !(recipe instanceof CraftingRecipe)) {
            this.moveForProcessing(recipeLayout, tracker);
        } else {
            this.move(gridContainer, recipeLayout, recipe);
        }
    }

    private void move(GridContainerMenu gridContainer, IRecipeLayout recipeLayout, Object recipe) {
        RS.NETWORK_HANDLER.sendToServer(new GridTransferMessage(recipeLayout.getItemStacks().getGuiIngredients(), gridContainer.f_38839_.stream().filter(s -> s.f_40218_ instanceof CraftingContainer).collect(Collectors.toList()), recipe instanceof CraftingRecipe));
    }

    private void moveForProcessing(IRecipeLayout recipeLayout, IngredientTracker tracker) {
        LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
        LinkedList<ItemStack> outputs = new LinkedList<ItemStack>();
        LinkedList<FluidStack> fluidInputs = new LinkedList<FluidStack>();
        LinkedList<FluidStack> fluidOutputs = new LinkedList<FluidStack>();
        for (IGuiIngredient guiIngredient : recipeLayout.getItemStacks().getGuiIngredients().values()) {
            this.handleItemIngredient(inputs, outputs, (IGuiIngredient<ItemStack>)guiIngredient, tracker);
        }
        for (IGuiIngredient guiIngredient : recipeLayout.getFluidStacks().getGuiIngredients().values()) {
            this.handleFluidIngredient(fluidInputs, fluidOutputs, (IGuiIngredient<FluidStack>)guiIngredient);
        }
        RS.NETWORK_HANDLER.sendToServer(new GridProcessingTransferMessage(inputs, outputs, fluidInputs, fluidOutputs));
    }

    private void handleFluidIngredient(List<FluidStack> fluidInputs, List<FluidStack> fluidOutputs, IGuiIngredient<FluidStack> guiIngredient) {
        if (guiIngredient != null && guiIngredient.getDisplayedIngredient() != null) {
            FluidStack ingredient = ((FluidStack)guiIngredient.getDisplayedIngredient()).copy();
            if (guiIngredient.isInput()) {
                fluidInputs.add(ingredient);
            } else {
                fluidOutputs.add(ingredient);
            }
        }
    }

    private void handleItemIngredient(List<ItemStack> inputs, List<ItemStack> outputs, IGuiIngredient<ItemStack> guiIngredient, IngredientTracker tracker) {
        if (guiIngredient != null && guiIngredient.getDisplayedIngredient() != null) {
            ItemStack ingredient = tracker.findBestMatch(guiIngredient.getAllIngredients()).m_41777_();
            if (ingredient == ItemStack.f_41583_) {
                ingredient = ((ItemStack)guiIngredient.getDisplayedIngredient()).m_41777_();
            }
            if (guiIngredient.isInput()) {
                inputs.add(ingredient);
            } else {
                outputs.add(ingredient);
            }
        }
    }
}

