/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.network.grid;

import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class GridFluidPullMessage {
    private final UUID id;
    private final boolean shift;

    public GridFluidPullMessage(UUID id, boolean shift) {
        this.id = id;
        this.shift = shift;
    }

    public static GridFluidPullMessage decode(FriendlyByteBuf buf) {
        return new GridFluidPullMessage(buf.m_130259_(), buf.readBoolean());
    }

    public static void encode(GridFluidPullMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.id);
        buf.writeBoolean(message.shift);
    }

    public static void handle(GridFluidPullMessage message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        if (player != null) {
            ctx.get().enqueueWork(() -> {
                IGrid grid;
                AbstractContainerMenu container = player.f_36096_;
                if (container instanceof GridContainerMenu && (grid = ((GridContainerMenu)container).getGrid()).getFluidHandler() != null) {
                    grid.getFluidHandler().onExtract(player, message.id, message.shift);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

