/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.recipe;

import com.google.common.collect.Lists;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.apiimpl.network.node.cover.CoverManager;
import com.refinedmods.refinedstorage.item.CoverItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class CoverRecipe
extends CustomRecipe {
    public static RecipeSerializer<CoverRecipe> SERIALIZER = new SimpleRecipeSerializer(CoverRecipe::new);

    public CoverRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public static boolean stackMatches(ItemStack first) {
        return CoverManager.isValidCover(first);
    }

    public static boolean matches(List<ItemStack> list) {
        return list.size() == 2;
    }

    public static ItemStack getResult(List<ItemStack> list) {
        if (list.size() == 2) {
            ItemStack first = list.get(0);
            ItemStack second = list.get(1);
            return CoverRecipe.getResult(first, second);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getResult(ItemStack first, ItemStack second) {
        if (first.m_150922_((Tag)Tags.Items.NUGGETS_IRON)) {
            ItemStack stack = new ItemStack((ItemLike)RSItems.COVER.get());
            CoverItem.setItem(stack, second);
            stack.m_41764_(6);
            return stack;
        }
        if (second.m_150922_((Tag)Tags.Items.NUGGETS_IRON)) {
            ItemStack stack = new ItemStack((ItemLike)RSItems.COVER.get());
            CoverItem.setItem(stack, first);
            stack.m_41764_(6);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ArrayList list = Lists.newArrayList();
        int ingots = 0;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack itemstack = craftingContainer.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            list.add(itemstack);
            if (itemstack.m_150922_((Tag)Tags.Items.NUGGETS_IRON)) {
                ++ingots;
                continue;
            }
            if (CoverRecipe.stackMatches(itemstack)) continue;
            return false;
        }
        return CoverRecipe.matches(list) && ingots == 1;
    }

    public ItemStack assemble(CraftingContainer inv) {
        ArrayList list = Lists.newArrayList();
        int ingots = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            list.add(itemstack);
            if (itemstack.m_150922_((Tag)Tags.Items.NUGGETS_IRON)) {
                ++ingots;
                continue;
            }
            if (CoverRecipe.stackMatches(itemstack)) continue;
            return ItemStack.f_41583_;
        }
        if (ingots > 1) {
            return ItemStack.f_41583_;
        }
        return CoverRecipe.getResult(list);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

