/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.blockentity;

import com.refinedmods.rangedpumps.RangedPumps;
import com.refinedmods.rangedpumps.blockentity.PumpState;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

public class PumpBlockEntity
extends BlockEntity {
    @ObjectHolder(value="rangedpumps:pump")
    public static final BlockEntityType<PumpBlockEntity> TYPE = null;
    private PumpTank tank = new PumpTank();
    private IEnergyStorage energy = new EnergyStorage(RangedPumps.SERVER_CONFIG.getEnergyCapacity());
    private final LazyOptional<IEnergyStorage> energyProxyCap = LazyOptional.of(() -> this.energy);
    private final LazyOptional<IFluidHandler> fluidHandlerCap = LazyOptional.of(() -> this.tank);
    private int ticks;
    @Nullable
    private BlockPos currentPos;
    private int range = -1;
    private Queue<BlockPos> surfaces = new LinkedList<BlockPos>();
    private Block blockToReplaceLiquidsWith;

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    private void rebuildSurfaces() {
        int i;
        this.surfaces.clear();
        if (this.range == -1) {
            this.surfaces.add(this.f_58858_.m_7495_());
            return;
        }
        int hl = 3 + 2 * this.range;
        int vl = 1 + 2 * this.range;
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.f_58858_.m_142082_(-this.range - 1 + i, -1, -this.range - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.f_58858_.m_142082_(-this.range - 1 + vl + 1, -1, -this.range - 1 + i + 1));
        }
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.f_58858_.m_142082_(-this.range - 1 + hl - i - 1, -1, -this.range - 1 + hl - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.f_58858_.m_142082_(-this.range - 1, -1, -this.range - 1 + vl - i));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.surfaces.isEmpty()) {
            this.rebuildSurfaces();
        }
    }

    public void tick() {
        if (!RangedPumps.SERVER_CONFIG.getUseEnergy()) {
            this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), false);
        }
        if (!this.tank.getFluid().isEmpty()) {
            LinkedList<IFluidHandler> fluidHandlers = new LinkedList<IFluidHandler>();
            for (Direction facing : Direction.values()) {
                IFluidHandler handler;
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
                if (blockEntity == null || (handler = (IFluidHandler)blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.m_122424_()).orElse(null)) == null) continue;
                fluidHandlers.add(handler);
            }
            if (!fluidHandlers.isEmpty()) {
                int transfer = (int)Math.floor((float)this.tank.getFluidAmount() / (float)fluidHandlers.size());
                for (IFluidHandler fluidHandler : fluidHandlers) {
                    FluidStack toFill = this.tank.getFluid().copy();
                    toFill.setAmount(transfer);
                    this.tank.drain(fluidHandler.fill(toFill, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        if ((RangedPumps.SERVER_CONFIG.getSpeed() == 0 || this.ticks % RangedPumps.SERVER_CONFIG.getSpeed() == 0) && this.getState() == PumpState.WORKING) {
            if (this.currentPos == null || this.currentPos.m_123342_() == 0) {
                if (this.surfaces.isEmpty()) {
                    ++this.range;
                    if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
                        return;
                    }
                    this.rebuildSurfaces();
                }
                this.currentPos = this.surfaces.poll();
            } else {
                this.currentPos = this.currentPos.m_7495_();
            }
            this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerMove(), false);
            FluidStack drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && this.tank.fillInternal(drained, IFluidHandler.FluidAction.SIMULATE) == drained.getAmount() && !(drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                this.tank.fillInternal(drained, IFluidHandler.FluidAction.EXECUTE);
                if (RangedPumps.SERVER_CONFIG.getReplaceLiquidWithBlock()) {
                    if (this.blockToReplaceLiquidsWith == null) {
                        this.blockToReplaceLiquidsWith = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(RangedPumps.SERVER_CONFIG.getBlockIdToReplaceLiquidsWith()));
                    }
                    if (this.blockToReplaceLiquidsWith != null) {
                        this.f_58857_.m_46597_(this.currentPos, this.blockToReplaceLiquidsWith.m_49966_());
                    }
                }
                this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerDrain(), false);
            }
            this.m_6596_();
        }
        ++this.ticks;
    }

    @Nonnull
    private FluidStack drainAt(BlockPos pos, IFluidHandler.FluidAction action) {
        IFluidBlock fluidBlock;
        BlockState frontBlockState = this.f_58857_.m_8055_(pos);
        Block frontBlock = frontBlockState.m_60734_();
        if (frontBlock instanceof LiquidBlock) {
            if ((Integer)frontBlockState.m_61143_((Property)LiquidBlock.f_54688_) == 0) {
                FlowingFluid fluid = ((LiquidBlock)frontBlock).getFluid();
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
                }
                return new FluidStack((Fluid)fluid, 1000);
            }
        } else if (frontBlock instanceof IFluidBlock && (fluidBlock = (IFluidBlock)frontBlock).canDrain(this.f_58857_, pos)) {
            return fluidBlock.drain(this.f_58857_, pos, action);
        }
        return FluidStack.EMPTY;
    }

    BlockPos getCurrentPosition() {
        return this.currentPos == null ? this.f_58858_.m_7495_() : this.currentPos;
    }

    int getRange() {
        return this.range;
    }

    PumpState getState() {
        if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
            return PumpState.DONE;
        }
        if (this.f_58857_.m_46753_(this.f_58858_)) {
            return PumpState.REDSTONE;
        }
        if (this.energy.getEnergyStored() == 0) {
            return PumpState.ENERGY;
        }
        if (this.tank.getFluidAmount() > this.tank.getCapacity() - 1000) {
            return PumpState.FULL;
        }
        return PumpState.WORKING;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        if (this.currentPos != null) {
            tag.m_128356_("CurrentPos", this.currentPos.m_121878_());
        }
        tag.m_128405_("Range", this.range);
        ListTag surfaces = new ListTag();
        this.surfaces.forEach(s -> surfaces.add((Object)LongTag.m_128882_((long)s.m_121878_())));
        tag.m_128365_("Surfaces", (Tag)surfaces);
        this.tank.writeToNBT(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Energy")) {
            this.energy.receiveEnergy(tag.m_128451_("Energy"), false);
        }
        if (tag.m_128441_("CurrentPos")) {
            this.currentPos = BlockPos.m_122022_((long)tag.m_128454_("CurrentPos"));
        }
        if (tag.m_128441_("Range")) {
            this.range = tag.m_128451_("Range");
        }
        if (tag.m_128441_("Surfaces")) {
            ListTag surfaces = tag.m_128437_("Surfaces", 4);
            for (Tag surface : surfaces) {
                this.surfaces.add(BlockPos.m_122022_((long)((LongTag)surface).m_7046_()));
            }
        }
        this.tank.readFromNBT(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyProxyCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerCap.cast();
        }
        return super.getCapability(cap, direction);
    }

    private static class PumpTank
    extends FluidTank {
        public PumpTank() {
            super(RangedPumps.SERVER_CONFIG.getTankCapacity());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    }
}

