/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone;

import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.AbstractPanelCellItem;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.RotationLock;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tinyredstone", value={Dist.CLIENT})
public class ClientBinding {
    public static KeyMapping rotationLock;

    public static void registerKeyBindings() {
        rotationLock = new KeyMapping("key.tinyredstone.rotation_lock", 342, "TinyRedstone");
        ClientRegistry.registerKeyBinding((KeyMapping)rotationLock);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent keyInputEvent) {
        if (keyInputEvent.isCanceled()) {
            return;
        }
        int numberKey = keyInputEvent.getKey() - 48;
        if (numberKey > 0 && numberKey <= 9) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_150109_().f_35977_ + 1 == numberKey) {
                return;
            }
            ItemStack mainHand = player.m_21205_();
            Item mainHandItem = mainHand.m_41720_();
            if (mainHandItem instanceof AbstractPanelCellItem) {
                RotationLock.removeLock();
            }
        }
    }

    @SubscribeEvent
    public static void wheelEvent(InputEvent.MouseScrollEvent mouseScrollEvent) {
        if (mouseScrollEvent.isCanceled()) {
            return;
        }
        double scrollDelta = mouseScrollEvent.getScrollDelta();
        if (scrollDelta == 0.0) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ItemStack mainHand = player.m_21205_();
        Item mainHandItem = mainHand.m_41720_();
        if (mainHandItem instanceof AbstractPanelCellItem) {
            if (rotationLock.m_90857_()) {
                Vec3 lookVector = Minecraft.m_91087_().f_91077_.m_82450_();
                BlockPos blockPos = new BlockPos(lookVector);
                BlockEntity te = world.m_7702_(blockPos);
                if (te instanceof PanelTile) {
                    try {
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(mainHandItem).getConstructors()[0].newInstance(new Object[0]);
                        RotationLock.lockRotation((PanelTile)te, (Player)player, panelCell.canPlaceVertical(), scrollDelta < 0.0);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to lock rotation: " + e.getMessage());
                    }
                } else {
                    try {
                        IPanelCell panelCell = (IPanelCell)PanelBlock.getPanelCellClassFromItem(mainHandItem).getConstructors()[0].newInstance(new Object[0]);
                        RotationLock.lockRotation(panelCell.canPlaceVertical(), scrollDelta < 0.0);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        TinyRedstone.LOGGER.error("Exception thrown when attempting to lock rotation: " + e.getMessage());
                    }
                }
                mouseScrollEvent.setCanceled(true);
            } else {
                RotationLock.removeLock();
            }
        }
    }
}

