/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.PanelOverflowException;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IObservingPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCover;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellGhostPos;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.Button;
import com.dannyandson.tinyredstone.blocks.panelcells.Piston;
import com.dannyandson.tinyredstone.blocks.panelcells.RedstoneDust;
import com.dannyandson.tinyredstone.blocks.panelcells.StickyPiston;
import com.dannyandson.tinyredstone.blocks.panelcells.StoneButton;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.PlaySound;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;

public class PanelTile
extends BlockEntity {
    private Map<Integer, IPanelCell> cells = new HashMap<Integer, IPanelCell>();
    private Map<Integer, Side> cellDirections = new HashMap<Integer, Side>();
    protected Map<Side, Integer> strongPowerToNeighbors = new HashMap<Side, Integer>();
    protected Map<Side, Integer> weakPowerToNeighbors = new HashMap<Side, Integer>();
    protected Map<Side, Integer> wirePowerToNeighbors = new HashMap<Side, Integer>();
    protected Integer Color = RenderHelper.getTextureDiffusedColor(DyeColor.GRAY);
    private Integer lightOutput = 0;
    protected boolean flagLightUpdate = false;
    private boolean flagCrashed = false;
    private boolean flagOverflow = false;
    protected IPanelCover panelCover = null;
    private boolean flagOutputUpdate = false;
    private boolean flagSync = true;
    protected PanelCellGhostPos panelCellGhostPos;
    protected PanelCellPos panelCellHovering;
    private VoxelShape voxelShape = null;
    protected static boolean checkWireSignals = true;

    public PanelTile(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Registration.REDSTONE_PANEL_TILE.get(), p_155229_, p_155230_);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.f_58857_.f_46443_) {
            this.cells.clear();
            this.cellDirections.clear();
        }
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        this.m_183515_(compoundtag);
        return compoundtag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (this.f_58857_.f_46443_) {
            this.cells.clear();
            this.cellDirections.clear();
        }
        this.m_142466_(tag);
    }

    public CompoundTag saveToNbt(CompoundTag compoundTag) {
        CompoundTag cellsNBT = new CompoundTag();
        for (Integer key : this.cells.keySet()) {
            IPanelCell cell = this.cells.get(key);
            CompoundTag cellNBT = new CompoundTag();
            cellNBT.m_128359_("class", cell.getClass().getCanonicalName());
            cellNBT.m_128359_("facing", this.cellDirections.get(key).name());
            cellNBT.m_128365_("data", (Tag)cell.writeNBT());
            cellsNBT.m_128365_(key.toString(), (Tag)cellNBT);
        }
        compoundTag.m_128365_("cells", (Tag)cellsNBT);
        if (this.Color.intValue() != DyeColor.GRAY.m_41060_()) {
            compoundTag.m_128405_("color", this.Color.intValue());
        }
        if (this.panelCover != null) {
            compoundTag.m_128359_("cover", this.panelCover.getClass().getCanonicalName());
            CompoundTag coverData = this.panelCover.writeNBT();
            if (coverData != null) {
                compoundTag.m_128365_("coverData", (Tag)coverData);
            }
        }
        return compoundTag;
    }

    protected void m_183515_(CompoundTag parentNBTTagCompound) {
        super.m_183515_(parentNBTTagCompound);
        try {
            if (this.strongPowerToNeighbors.size() == 5) {
                CompoundTag strongPowerToNeighbors = new CompoundTag();
                strongPowerToNeighbors.m_128405_("" + Side.FRONT.ordinal(), this.strongPowerToNeighbors.get((Object)Side.FRONT).intValue());
                strongPowerToNeighbors.m_128405_("" + Side.RIGHT.ordinal(), this.strongPowerToNeighbors.get((Object)Side.RIGHT).intValue());
                strongPowerToNeighbors.m_128405_("" + Side.BACK.ordinal(), this.strongPowerToNeighbors.get((Object)Side.BACK).intValue());
                strongPowerToNeighbors.m_128405_("" + Side.LEFT.ordinal(), this.strongPowerToNeighbors.get((Object)Side.LEFT).intValue());
                strongPowerToNeighbors.m_128405_("" + Side.TOP.ordinal(), this.strongPowerToNeighbors.get((Object)Side.TOP).intValue());
                if (!this.hasBase()) {
                    strongPowerToNeighbors.m_128405_("" + Side.BOTTOM.ordinal(), this.strongPowerToNeighbors.get((Object)Side.BOTTOM).intValue());
                }
                parentNBTTagCompound.m_128365_("strong_power_outgoing", (Tag)strongPowerToNeighbors);
            }
            if (this.weakPowerToNeighbors.size() == 5) {
                CompoundTag weakPowerToNeighbors = new CompoundTag();
                weakPowerToNeighbors.m_128405_("" + Side.FRONT.ordinal(), this.weakPowerToNeighbors.get((Object)Side.FRONT).intValue());
                weakPowerToNeighbors.m_128405_("" + Side.RIGHT.ordinal(), this.weakPowerToNeighbors.get((Object)Side.RIGHT).intValue());
                weakPowerToNeighbors.m_128405_("" + Side.BACK.ordinal(), this.weakPowerToNeighbors.get((Object)Side.BACK).intValue());
                weakPowerToNeighbors.m_128405_("" + Side.LEFT.ordinal(), this.weakPowerToNeighbors.get((Object)Side.LEFT).intValue());
                weakPowerToNeighbors.m_128405_("" + Side.TOP.ordinal(), this.weakPowerToNeighbors.get((Object)Side.TOP).intValue());
                if (!this.hasBase()) {
                    weakPowerToNeighbors.m_128405_("" + Side.BOTTOM.ordinal(), this.weakPowerToNeighbors.get((Object)Side.BOTTOM).intValue());
                }
                parentNBTTagCompound.m_128365_("weak_power_outgoing", (Tag)weakPowerToNeighbors);
            }
            if (this.wirePowerToNeighbors.size() == 5) {
                CompoundTag wirePowerToNeighbors = new CompoundTag();
                wirePowerToNeighbors.m_128405_("" + Side.FRONT.ordinal(), this.wirePowerToNeighbors.get((Object)Side.FRONT).intValue());
                wirePowerToNeighbors.m_128405_("" + Side.RIGHT.ordinal(), this.wirePowerToNeighbors.get((Object)Side.RIGHT).intValue());
                wirePowerToNeighbors.m_128405_("" + Side.BACK.ordinal(), this.wirePowerToNeighbors.get((Object)Side.BACK).intValue());
                wirePowerToNeighbors.m_128405_("" + Side.LEFT.ordinal(), this.wirePowerToNeighbors.get((Object)Side.LEFT).intValue());
                wirePowerToNeighbors.m_128405_("" + Side.TOP.ordinal(), this.wirePowerToNeighbors.get((Object)Side.TOP).intValue());
                parentNBTTagCompound.m_128365_("wire_power_outgoing", (Tag)wirePowerToNeighbors);
            }
            parentNBTTagCompound.m_128405_("lightOutput", this.lightOutput.intValue());
            parentNBTTagCompound.m_128379_("flagLightUpdate", this.flagLightUpdate);
            parentNBTTagCompound.m_128379_("flagCrashed", this.flagCrashed);
            parentNBTTagCompound.m_128379_("flagOverflow", this.flagOverflow);
            parentNBTTagCompound.m_128379_("flagOutputUpdate", this.flagOutputUpdate);
        }
        catch (NullPointerException exception) {
            TinyRedstone.LOGGER.error("Exception thrown when attempting to save power inputs and outputs: " + exception.toString() + (exception.getStackTrace().length > 0 ? exception.getStackTrace()[0].toString() : ""));
        }
        this.saveToNbt(parentNBTTagCompound);
    }

    public void m_142466_(CompoundTag parentNBTTagCompound) {
        String coverClass;
        CompoundTag wirePowerToNeighbors;
        CompoundTag weakPowerToNeighbors;
        int previousLightOutput = this.lightOutput;
        super.m_142466_(parentNBTTagCompound);
        this.loadCellsFromNBT(parentNBTTagCompound);
        CompoundTag strongPowerToNeighbors = parentNBTTagCompound.m_128469_("strong_power_outgoing");
        if (!strongPowerToNeighbors.m_128456_()) {
            this.strongPowerToNeighbors.put(Side.FRONT, strongPowerToNeighbors.m_128451_("" + Side.FRONT.ordinal()));
            this.strongPowerToNeighbors.put(Side.RIGHT, strongPowerToNeighbors.m_128451_("" + Side.RIGHT.ordinal()));
            this.strongPowerToNeighbors.put(Side.BACK, strongPowerToNeighbors.m_128451_("" + Side.BACK.ordinal()));
            this.strongPowerToNeighbors.put(Side.LEFT, strongPowerToNeighbors.m_128451_("" + Side.LEFT.ordinal()));
            this.strongPowerToNeighbors.put(Side.TOP, strongPowerToNeighbors.m_128451_("" + Side.TOP.ordinal()));
            if (!this.hasBase()) {
                this.strongPowerToNeighbors.put(Side.BOTTOM, strongPowerToNeighbors.m_128451_("" + Side.BOTTOM.ordinal()));
            }
        }
        if (!(weakPowerToNeighbors = parentNBTTagCompound.m_128469_("weak_power_outgoing")).m_128456_()) {
            this.weakPowerToNeighbors.put(Side.FRONT, weakPowerToNeighbors.m_128451_("" + Side.FRONT.ordinal()));
            this.weakPowerToNeighbors.put(Side.RIGHT, weakPowerToNeighbors.m_128451_("" + Side.RIGHT.ordinal()));
            this.weakPowerToNeighbors.put(Side.BACK, weakPowerToNeighbors.m_128451_("" + Side.BACK.ordinal()));
            this.weakPowerToNeighbors.put(Side.LEFT, weakPowerToNeighbors.m_128451_("" + Side.LEFT.ordinal()));
            this.weakPowerToNeighbors.put(Side.TOP, weakPowerToNeighbors.m_128451_("" + Side.TOP.ordinal()));
            if (!this.hasBase()) {
                this.weakPowerToNeighbors.put(Side.BOTTOM, weakPowerToNeighbors.m_128451_("" + Side.BOTTOM.ordinal()));
            }
        }
        if (!(wirePowerToNeighbors = parentNBTTagCompound.m_128469_("wire_power_outgoing")).m_128456_()) {
            this.wirePowerToNeighbors.put(Side.FRONT, wirePowerToNeighbors.m_128451_("" + Side.FRONT.ordinal()));
            this.wirePowerToNeighbors.put(Side.RIGHT, wirePowerToNeighbors.m_128451_("" + Side.RIGHT.ordinal()));
            this.wirePowerToNeighbors.put(Side.BACK, wirePowerToNeighbors.m_128451_("" + Side.BACK.ordinal()));
            this.wirePowerToNeighbors.put(Side.LEFT, wirePowerToNeighbors.m_128451_("" + Side.LEFT.ordinal()));
            this.wirePowerToNeighbors.put(Side.TOP, wirePowerToNeighbors.m_128451_("" + Side.TOP.ordinal()));
        }
        this.lightOutput = parentNBTTagCompound.m_128451_("lightOutput");
        this.flagLightUpdate = parentNBTTagCompound.m_128471_("flagLightUpdate");
        this.flagCrashed = parentNBTTagCompound.m_128471_("flagCrashed");
        this.flagOverflow = parentNBTTagCompound.m_128471_("flagOverflow");
        this.flagOutputUpdate = parentNBTTagCompound.m_128471_("flagOutputUpdate");
        if (parentNBTTagCompound.m_128441_("color")) {
            int color = parentNBTTagCompound.m_128451_("color");
            if (this.Color != color) {
                this.Color = color;
            }
        }
        if ((coverClass = parentNBTTagCompound.m_128461_("cover")).length() > 0) {
            try {
                this.panelCover = (IPanelCover)Class.forName(coverClass).getConstructor(new Class[0]).newInstance(new Object[0]);
                if (parentNBTTagCompound.m_128441_("coverData")) {
                    this.panelCover.readNBT(parentNBTTagCompound.m_128469_("coverData"));
                }
            }
            catch (Exception exception) {
                TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCover class " + coverClass, (Throwable)exception);
            }
        } else {
            this.panelCover = null;
        }
        if (this.lightOutput != previousLightOutput && this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_142202_(this.f_58858_);
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            try {
                this.updateSide(Side.FRONT);
                this.updateSide(Side.RIGHT);
                this.updateSide(Side.BACK);
                this.updateSide(Side.LEFT);
                this.updateSide(Side.TOP);
                this.updateSide(Side.BOTTOM);
                this.flagOutputUpdate();
            }
            catch (PanelOverflowException e) {
                this.handleCrash(e);
            }
        }
    }

    public void loadCellsFromNBT(CompoundTag parentNBTTagCompound) {
        CompoundTag cellsNBT = parentNBTTagCompound.m_128469_("cells");
        for (String index : cellsNBT.m_128431_()) {
            CompoundTag cellNBT = cellsNBT.m_128469_(index);
            if (!cellNBT.m_128441_("data")) continue;
            String className = cellNBT.m_128461_("class");
            try {
                IPanelCell cell = (IPanelCell)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                cell.readNBT(cellNBT.m_128469_("data"));
                Integer i = Integer.parseInt(index);
                this.cells.put(i, cell);
                if (cellNBT.m_128441_("direction")) {
                    Direction direction = Direction.m_122376_((int)cellNBT.m_128451_("direction"));
                    if (direction == Direction.NORTH) {
                        this.cellDirections.put(i, Side.FRONT);
                        continue;
                    }
                    if (direction == Direction.EAST) {
                        this.cellDirections.put(i, Side.RIGHT);
                        continue;
                    }
                    if (direction == Direction.SOUTH) {
                        this.cellDirections.put(i, Side.BACK);
                        continue;
                    }
                    if (direction != Direction.WEST) continue;
                    this.cellDirections.put(i, Side.LEFT);
                    continue;
                }
                this.cellDirections.put(i, Side.valueOf(cellNBT.m_128461_("facing")));
            }
            catch (Exception exception) {
                TinyRedstone.LOGGER.error("Exception attempting to construct IPanelCell class " + className, (Throwable)exception);
            }
        }
        this.flagVoxelShapeUpdate();
    }

    public void removeOutOfRange(Player player) {
        if (this.hasBase()) {
            ArrayList<Integer> indices = new ArrayList<Integer>(this.cells.keySet());
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i <= 447) continue;
                ((PanelBlock)this.m_58900_().m_60734_()).removeCell(PanelCellPos.fromIndex(this, i), player);
            }
        }
    }

    public void tick() {
        try {
            if (!this.flagCrashed && !this.flagOverflow) {
                if (this.f_58857_.f_46443_) {
                    if (this.isCovered()) {
                        this.panelCellGhostPos = null;
                        this.panelCellHovering = null;
                    } else {
                        PanelCellGhostPos gPos = PanelTileRenderer.getPlayerLookingAtCell(this);
                        if (gPos != null) {
                            gPos.getPanelTile().panelCellGhostPos = gPos;
                        } else {
                            this.panelCellGhostPos = null;
                        }
                    }
                } else {
                    boolean dirty = false;
                    ArrayList<Integer> pistons = null;
                    TreeSet<Integer> keys = new TreeSet<Integer>(this.cells.keySet());
                    for (Integer index : keys) {
                        PanelCellPos cellPos = PanelCellPos.fromIndex(this, index);
                        IPanelCell panelCell = this.cells.get(index);
                        boolean update = panelCell.tick(cellPos);
                        if (!update) continue;
                        if (panelCell instanceof Piston) {
                            if (pistons == null) {
                                pistons = new ArrayList<Integer>();
                            }
                            pistons.add(index);
                        } else {
                            if (panelCell instanceof Button) {
                                for (Player player : this.m_58904_().m_6907_()) {
                                    if (!(player.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 64.0)) continue;
                                    ModNetworkHandler.sendToClient(new PlaySound(this.m_58899_(), "minecraft", panelCell instanceof StoneButton ? "block.stone_button.click_off" : "block.wooden_button.click_off", 0.25f, 2.0f), (ServerPlayer)player);
                                }
                            }
                            this.updateNeighborCells(cellPos);
                        }
                        dirty = true;
                    }
                    if (pistons != null) {
                        for (Integer index : pistons) {
                            this.updatePiston(index);
                        }
                    }
                    if (this.flagLightUpdate) {
                        this.flagLightUpdate = false;
                        this.f_58857_.m_5518_().m_142202_(this.f_58858_);
                    }
                    if (this.flagOutputUpdate) {
                        this.updateOutputs();
                    }
                    if (this.flagSync || dirty) {
                        this.sync();
                        this.flagSync = false;
                    }
                    if (this.cells.size() == 0 && !this.hasBase()) {
                        this.f_58857_.m_46961_(this.f_58858_, true);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleCrash(e);
        }
    }

    private void updatePiston(int index) throws PanelOverflowException {
        IPanelCell panelCell = this.cells.get(index);
        if (panelCell instanceof Piston) {
            PanelCellPos abovePiston;
            PanelTile panelTile = this;
            PanelCellPos pistonPos = PanelCellPos.fromIndex(this, index);
            Side movingToward = pistonPos.getCellFacing().getOpposite();
            PanelCellPos moverPos = pistonPos.offset(movingToward);
            if (!((Piston)panelCell).isExtended() && panelCell instanceof StickyPiston && moverPos != null && moverPos.getIPanelCell() == null) {
                moverPos = moverPos.offset(movingToward);
                movingToward = movingToward.getOpposite();
                if (moverPos.getIPanelCell() != null && moverPos.getIPanelCell().needsSolidBase()) {
                    moverPos = null;
                }
            }
            for (Player player : this.m_58904_().m_6907_()) {
                if (!(player.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 64.0)) continue;
                ModNetworkHandler.sendToClient(new PlaySound(this.m_58899_(), "minecraft", ((Piston)panelCell).isExtended() ? "block.piston.extend" : "block.piston.contract", 0.25f, 2.0f), (ServerPlayer)player);
            }
            if (moverPos != null) {
                PanelTile moverPanelTile = moverPos.getPanelTile();
                if (moverPanelTile.cells.containsKey(moverPos.getIndex())) {
                    panelTile.moveCell(moverPos, movingToward, 0);
                } else {
                    panelTile.updateNeighborCells(moverPos);
                }
            }
            if ((abovePiston = pistonPos.offset(Side.TOP)) != null && abovePiston.getIPanelCell() != null) {
                panelTile.updateCell(abovePiston);
            }
        }
    }

    private boolean moveCell(PanelCellPos cellPos, Side towardSide, Integer iteration) throws PanelOverflowException {
        if (iteration > 12) {
            return false;
        }
        IPanelCell cell = cellPos.getIPanelCell();
        if (cell == null) {
            return true;
        }
        if (cell.needsSolidBase()) {
            ((PanelBlock)Registration.REDSTONE_PANEL_BLOCK.get()).removeCell(cellPos, null);
            return true;
        }
        if (!cell.isPushable()) {
            return false;
        }
        PanelCellPos newPos = cellPos.offset(towardSide);
        if (newPos == null || newPos.getIPanelCell() != null && !newPos.getPanelTile().moveCell(newPos, towardSide, iteration + 1)) {
            return false;
        }
        int oldIndex = cellPos.getIndex();
        int newIndex = newPos.getIndex();
        newPos.getPanelTile().cells.put(newIndex, cell);
        newPos.getPanelTile().cellDirections.put(newIndex, cellPos.getCellFacing());
        cellPos.getPanelTile().cells.remove(oldIndex);
        cellPos.getPanelTile().cellDirections.remove(oldIndex);
        newPos.getPanelTile().updateNeighborCells(newPos);
        cellPos.getPanelTile().updateNeighborCells(cellPos);
        newPos.getPanelTile().flagSync = true;
        newPos.getPanelTile().flagVoxelShapeUpdate();
        cellPos.getPanelTile().flagSync = true;
        cellPos.getPanelTile().flagVoxelShapeUpdate();
        if (cell instanceof IObservingPanelCell) {
            ((IObservingPanelCell)((Object)cell)).frontNeighborUpdated();
        }
        return true;
    }

    public boolean canExtendTo(PanelCellPos cellPos, Side side, Integer iteration) {
        if (iteration > 12) {
            return false;
        }
        IPanelCell iPanelCell = cellPos.getIPanelCell();
        if (this.checkCellForPistonExtension(cellPos)) {
            return false;
        }
        if (iPanelCell == null) {
            return true;
        }
        if (iPanelCell.needsSolidBase()) {
            return true;
        }
        if (!iPanelCell.isPushable()) {
            return false;
        }
        PanelCellPos adjacentPos = cellPos.offset(side);
        if (adjacentPos == null) {
            return false;
        }
        return adjacentPos.getPanelTile().canExtendTo(adjacentPos, side, iteration + 1);
    }

    public void rotate(Rotation rotationIn) {
        HashMap<Integer, IPanelCell> cells = new HashMap<Integer, IPanelCell>();
        HashMap<Integer, Side> cellDirections = new HashMap<Integer, Side>();
        for (Integer i : this.cells.keySet()) {
            Side side2;
            PanelCellPos cellPos2;
            PanelCellPos cellPos1 = PanelCellPos.fromIndex(this, i);
            Side side1 = this.cellDirections.get(i);
            if (rotationIn == Rotation.COUNTERCLOCKWISE_90) {
                cellPos2 = PanelCellPos.fromRowColumn(this, cellPos1.getColumn(), (cellPos1.getRow() - 4) * -1 + 3, cellPos1.getLevel());
                side2 = side1.rotateYCCW();
            } else if (rotationIn == Rotation.CLOCKWISE_180) {
                cellPos2 = PanelCellPos.fromRowColumn(this, (cellPos1.getRow() - 4) * -1 + 3, (cellPos1.getColumn() - 4) * -1 + 3, cellPos1.getLevel());
                side2 = side1.getOpposite();
            } else {
                cellPos2 = PanelCellPos.fromRowColumn(this, (cellPos1.getColumn() - 4) * -1 + 3, cellPos1.getRow(), cellPos1.getLevel());
                side2 = side1.rotateYCW();
            }
            cells.put(cellPos2.getIndex(), this.cells.get(i));
            cellDirections.put(cellPos2.getIndex(), side2);
        }
        this.cells = cells;
        this.cellDirections = cellDirections;
        try {
            this.updateSide(Side.FRONT);
            this.updateSide(Side.RIGHT);
            this.updateSide(Side.BACK);
            this.updateSide(Side.LEFT);
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
            }
            this.updateOutputs();
            this.flagVoxelShapeUpdate();
            this.flagSync();
        }
        catch (PanelOverflowException e) {
            this.handleCrash(e);
        }
    }

    public boolean pingOutwardObservers(Direction facing) {
        boolean updated = false;
        Side side = this.getSideFromDirection(facing);
        List<Integer> cellIndices = this.getEdgeCellIndices(side);
        for (Integer i : cellIndices) {
            if (!this.cells.containsKey(i) || !(this.cells.get(i) instanceof IObservingPanelCell) || this.cellDirections.get(i) != side || !((IObservingPanelCell)((Object)this.cells.get(i))).frontNeighborUpdated()) continue;
            updated = true;
        }
        return updated;
    }

    public void updateSide(Direction facing) throws PanelOverflowException {
        this.updateSide(this.getSideFromDirection(facing));
    }

    public void updateSide(Side side) throws PanelOverflowException {
        List<Integer> cellIndices = this.getEdgeCellIndices(side);
        for (Integer i : cellIndices) {
            if (!this.cells.containsKey(i)) continue;
            this.updateCell(i);
        }
    }

    public boolean updateNeighborCells(PanelCellPos cellPos) throws PanelOverflowException {
        return this.updateNeighborCells(cellPos, 1);
    }

    private boolean updateNeighborCells(PanelCellPos cellPos, Integer iteration) throws PanelOverflowException {
        ArrayList<PanelCellPos> cellPosList = new ArrayList<PanelCellPos>();
        boolean updateOutputs = false;
        if (this.updateNeighbor(cellPos, Side.FRONT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.RIGHT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.BACK, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.LEFT, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.TOP, cellPosList)) {
            updateOutputs = true;
        }
        if (this.updateNeighbor(cellPos, Side.BOTTOM, cellPosList)) {
            updateOutputs = true;
        }
        for (PanelCellPos updatePos : cellPosList) {
            this.updateCell(updatePos, iteration + 1);
        }
        if (updateOutputs) {
            this.flagOutputUpdate();
        }
        return updateOutputs;
    }

    private boolean updateNeighbor(PanelCellPos cellPos, Side side, List<PanelCellPos> cellPosList) {
        PanelCellPos neighborPos = cellPos.offset(side);
        if (neighborPos == null) {
            return true;
        }
        IPanelCell adjacentCell = neighborPos.getIPanelCell();
        if (adjacentCell instanceof IObservingPanelCell) {
            Side direction2;
            Side direction1 = neighborPos.getCellFacing();
            if (direction1 == (direction2 = side.getOpposite())) {
                ((IObservingPanelCell)((Object)adjacentCell)).frontNeighborUpdated();
            }
        } else if (adjacentCell != null && (!adjacentCell.isIndependentState() || adjacentCell.needsSolidBase() && side.getOpposite() == neighborPos.getBaseDirection())) {
            cellPosList.add(neighborPos);
        }
        return false;
    }

    public boolean checkCellForPistonExtension(PanelCellPos cellPos) {
        for (Side panelSide : new Side[]{Side.FRONT, Side.RIGHT, Side.BACK, Side.LEFT, Side.TOP, Side.BOTTOM}) {
            IPanelCell cell;
            PanelCellPos neighborPos = cellPos.offset(panelSide);
            if (neighborPos == null || !((cell = neighborPos.getIPanelCell()) instanceof Piston) || neighborPos.getCellFacing() != panelSide || !((Piston)cell).isExtended()) continue;
            return true;
        }
        return false;
    }

    protected void updateCell(Integer cellIndex) throws PanelOverflowException {
        PanelCellPos cellPos = PanelCellPos.fromIndex(this, cellIndex);
        this.updateCell(cellPos, 1);
    }

    protected void updateCell(PanelCellPos cellPos) throws PanelOverflowException {
        this.updateCell(cellPos, 1);
    }

    private void updateCell(PanelCellPos cellPos, int iteration) throws PanelOverflowException {
        boolean change = false;
        if (iteration > 16 * (Integer)Config.CIRCUIT_MAX_ITERATION.get() || this.flagOverflow) {
            if (!this.flagOverflow) {
                TinyRedstone.LOGGER.warn("Redstone panel at " + this.f_58858_.m_123341_() + "," + this.f_58858_.m_123342_() + "," + this.f_58858_.m_123343_() + " iterated too many times.");
            }
            this.flagOverflow = true;
            throw new PanelOverflowException("Redstone Panel iterated too many times.");
        }
        if (cellPos.getPanelTile() != this) {
            cellPos.getPanelTile().updateCell(cellPos, iteration);
            return;
        }
        IPanelCell thisCell = cellPos.getIPanelCell();
        if (thisCell != null) {
            Side baseDirection;
            PanelCellPos basePos;
            if (!(!thisCell.needsSolidBase() || (basePos = cellPos.offset(baseDirection = cellPos.getBaseDirection())) == null || basePos.getIPanelCell() != null && (basePos.getIPanelCell().isPushable() || basePos.getIPanelCell() instanceof Piston && basePos.getCellFacing() == cellPos.getBaseDirection().getOpposite()))) {
                ((PanelBlock)Registration.REDSTONE_PANEL_BLOCK.get()).removeCell(cellPos, null);
                change = true;
            }
            if (!change && !thisCell.isIndependentState() && thisCell.neighborChanged(cellPos)) {
                this.updateNeighborCells(cellPos, iteration + 1);
                if (thisCell instanceof RedstoneDust) {
                    PanelCellPos above = cellPos.offset(Side.TOP);
                    PanelCellPos below = cellPos.offset(Side.BOTTOM);
                    if (above != null) {
                        this.updateNeighborCells(above, iteration + 1);
                    }
                    if (below != null) {
                        this.updateNeighborCells(below, iteration + 1);
                    }
                }
                change = true;
            }
        }
        if (change) {
            this.flagSync();
        }
    }

    private Side getPanelCellSide(PanelCellPos cellPos, Direction facing) {
        return this.getPanelCellSide(cellPos, this.getSideFromDirection(facing));
    }

    public Side getPanelCellSide(PanelCellPos cellPos, Side panelSide) {
        Side cellDirection = cellPos.getPanelTile().getCellFacing(cellPos);
        if (cellDirection == null) {
            return null;
        }
        if (cellDirection == panelSide) {
            return Side.FRONT;
        }
        if ((panelSide == Side.TOP || panelSide == Side.BOTTOM) && cellDirection != Side.TOP && cellDirection != Side.BOTTOM) {
            return panelSide;
        }
        if (cellDirection == panelSide.getOpposite()) {
            return Side.BACK;
        }
        if (cellDirection == panelSide.rotateYCW()) {
            return Side.LEFT;
        }
        if (cellDirection == panelSide.rotateYCCW()) {
            return Side.RIGHT;
        }
        if (cellDirection == panelSide.rotateForward()) {
            return Side.TOP;
        }
        if (cellDirection == panelSide.rotateBack()) {
            return Side.BOTTOM;
        }
        if (cellDirection == Side.TOP || cellDirection == Side.BOTTOM) {
            return panelSide;
        }
        return null;
    }

    public void flagOutputUpdate() {
        this.flagOutputUpdate = true;
    }

    public boolean isFlagOutputUpdate() {
        return this.flagOutputUpdate;
    }

    protected boolean updateOutputs() {
        boolean change = false;
        ArrayList<Direction> directionsUpdated = new ArrayList<Direction>();
        Side[] sides = this.hasBase() ? new Side[]{Side.FRONT, Side.RIGHT, Side.BACK, Side.LEFT, Side.TOP} : new Side[]{Side.FRONT, Side.RIGHT, Side.BACK, Side.LEFT, Side.TOP, Side.BOTTOM};
        for (Side panelSide : sides) {
            Direction direction = this.getDirectionFromSide(panelSide);
            BlockState neighborBlockState = this.f_58857_.m_8055_(this.f_58858_.m_142300_(direction));
            boolean neighborIsWire = PanelCellNeighbor.blockIsRedstoneWire(neighborBlockState.m_60734_());
            int weak = 0;
            int strong = 0;
            int wire = 0;
            List<Integer> indices = this.getEdgeCellIndices(direction);
            for (int i : indices) {
                int cellWireOutput;
                PanelCellPos cellPos = PanelCellPos.fromIndex(this, i);
                IPanelCell cell = cellPos.getIPanelCell();
                Side side = this.getPanelCellSide(cellPos, direction);
                int cellStrongOutput = !neighborIsWire && cell instanceof TinyBlock || cell instanceof RedstoneDust ? 0 : cell.getStrongRsOutput(side);
                int cellWeakOutput = cell.getWeakRsOutput(side);
                int n = cellWireOutput = cell instanceof RedstoneDust ? cellWeakOutput : 0;
                if (cell.powerDrops()) {
                    if (neighborIsWire) {
                        --cellStrongOutput;
                        --cellWeakOutput;
                        --cellWireOutput;
                    } else {
                        cellStrongOutput = 0;
                    }
                }
                if (cell instanceof TinyBlock && neighborIsWire) {
                    cellWeakOutput = cellStrongOutput;
                }
                if (cellStrongOutput > strong) {
                    strong = cellStrongOutput;
                }
                if (cellWeakOutput > weak) {
                    weak = cellWeakOutput;
                }
                if (cellWireOutput <= wire) continue;
                wire = cellWireOutput;
            }
            if (this.strongPowerToNeighbors.get((Object)panelSide) != null && strong == this.strongPowerToNeighbors.get((Object)panelSide) && this.weakPowerToNeighbors.get((Object)panelSide) != null && weak == this.weakPowerToNeighbors.get((Object)panelSide) && this.wirePowerToNeighbors.get((Object)panelSide) != null && wire == this.wirePowerToNeighbors.get((Object)panelSide)) continue;
            change = true;
            this.strongPowerToNeighbors.put(panelSide, strong);
            this.weakPowerToNeighbors.put(panelSide, weak);
            this.wirePowerToNeighbors.put(panelSide, wire);
            directionsUpdated.add(direction);
        }
        int ll = 0;
        for (Integer index : this.cells.keySet()) {
            ll += this.cells.get(index).lightOutput();
        }
        if (ll != this.lightOutput) {
            this.lightOutput = ll;
            this.flagLightUpdate = true;
        }
        if (change) {
            this.flagSync();
            this.m_6596_();
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            for (Direction direction : directionsUpdated) {
                BlockPos neighborPos = this.f_58858_.m_142300_(direction);
                BlockState neighborBlockState = this.f_58857_.m_8055_(neighborPos);
                if (neighborBlockState == null || !neighborBlockState.m_60815_()) continue;
                this.f_58857_.m_46672_(neighborPos, neighborBlockState.m_60734_());
            }
        }
        this.flagOutputUpdate = false;
        return change;
    }

    public static boolean getCheckWireSignals() {
        return checkWireSignals;
    }

    private List<Integer> getEdgeCellIndices(Direction edge) {
        return this.getEdgeCellIndices(this.getSideFromDirection(edge));
    }

    private List<Integer> getEdgeCellIndices(Side side) {
        ArrayList<Integer> cellIndices;
        block11: {
            int i;
            block10: {
                cellIndices = new ArrayList<Integer>();
                boolean hasBase = this.hasBase();
                for (int i1 = 0; i1 < (hasBase ? 447 : 511); i1 += 64) {
                    int i2;
                    if (side == Side.LEFT) {
                        for (i2 = i1; i2 < i1 + 8; ++i2) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                        continue;
                    }
                    if (side == Side.FRONT) {
                        for (i2 = i1; i2 < i1 + 64; i2 += 8) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                        continue;
                    }
                    if (side == Side.RIGHT) {
                        for (i2 = i1 + 56; i2 < i1 + 64; ++i2) {
                            if (!this.cells.containsKey(i2)) continue;
                            cellIndices.add(i2);
                        }
                        continue;
                    }
                    if (side != Side.BACK) continue;
                    for (i2 = i1 + 7; i2 < i1 + 64; i2 += 8) {
                        if (!this.cells.containsKey(i2)) continue;
                        cellIndices.add(i2);
                    }
                }
                if (side != Side.TOP) break block10;
                for (i = hasBase ? 384 : 448; i < (hasBase ? 448 : 512); ++i) {
                    if (!this.cells.containsKey(i)) continue;
                    cellIndices.add(i);
                }
                break block11;
            }
            if (side != Side.BOTTOM) break block11;
            for (i = 0; i < 64; ++i) {
                if (!this.cells.containsKey(i)) continue;
                cellIndices.add(i);
            }
        }
        return cellIndices;
    }

    public int getColor() {
        if (this.Color == null) {
            return RenderHelper.getTextureDiffusedColor(DyeColor.GRAY);
        }
        return this.Color;
    }

    public int getLightOutput() {
        if (this.panelCover == null || this.panelCover.allowsLightOutput()) {
            return this.lightOutput;
        }
        return 0;
    }

    public void sync() {
        if (!(this.f_58857_.f_46443_ || this.isCovered() && !this.panelCover.allowsLightOutput())) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.flagVoxelShapeUpdate();
        }
        this.m_6596_();
    }

    public void handleCrash(Exception e) {
        if (e instanceof PanelOverflowException) {
            PanelOverflowException pe = (PanelOverflowException)e;
            this.flagOverflow = true;
        } else {
            this.flagCrashed = true;
        }
        TinyRedstone.LOGGER.error("Redstone Panel Crashed at " + this.f_58858_.m_123341_() + "," + this.f_58858_.m_123342_() + "," + this.f_58858_.m_123343_(), (Throwable)e);
        this.sync();
    }

    public boolean isCrashed() {
        return this.flagCrashed;
    }

    public void resetCrashFlag() {
        this.flagCrashed = false;
    }

    public boolean isOverflown() {
        return this.flagOverflow;
    }

    public void resetOverflownFlag() {
        this.flagOverflow = false;
    }

    public boolean isCovered() {
        return this.panelCover != null;
    }

    protected Direction getDirectionFromSide(Side side) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        switch (side) {
            case FRONT: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Direction.NORTH;
                    }
                    case UP: {
                        return Direction.SOUTH;
                    }
                    case SOUTH: {
                        return Direction.DOWN;
                    }
                    case NORTH: {
                        return Direction.UP;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Direction.EAST;
                    }
                    case EAST: {
                        return Direction.UP;
                    }
                    case WEST: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case BACK: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Direction.SOUTH;
                    }
                    case UP: {
                        return Direction.NORTH;
                    }
                    case SOUTH: {
                        return Direction.UP;
                    }
                    case NORTH: {
                        return Direction.DOWN;
                    }
                }
                break;
            }
            case LEFT: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Direction.WEST;
                    }
                    case EAST: {
                        return Direction.DOWN;
                    }
                    case WEST: {
                        return Direction.UP;
                    }
                }
            }
            case TOP: {
                return facing.m_122424_();
            }
            case BOTTOM: {
                return facing;
            }
        }
        return null;
    }

    public Side getSideFromDirection(Direction direction) {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        switch (direction) {
            case NORTH: {
                switch (facing) {
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Side.FRONT;
                    }
                    case UP: {
                        return Side.BACK;
                    }
                    case NORTH: {
                        return Side.BOTTOM;
                    }
                    case SOUTH: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case EAST: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Side.RIGHT;
                    }
                    case EAST: {
                        return Side.BOTTOM;
                    }
                    case WEST: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (facing) {
                    case UP: {
                        return Side.FRONT;
                    }
                    case DOWN: 
                    case EAST: 
                    case WEST: {
                        return Side.BACK;
                    }
                    case SOUTH: {
                        return Side.BOTTOM;
                    }
                    case NORTH: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case WEST: {
                switch (facing) {
                    case DOWN: 
                    case UP: 
                    case SOUTH: 
                    case NORTH: {
                        return Side.LEFT;
                    }
                    case WEST: {
                        return Side.BOTTOM;
                    }
                    case EAST: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case UP: {
                switch (facing) {
                    case NORTH: {
                        return Side.FRONT;
                    }
                    case EAST: {
                        return Side.RIGHT;
                    }
                    case SOUTH: {
                        return Side.BACK;
                    }
                    case WEST: {
                        return Side.LEFT;
                    }
                    case UP: {
                        return Side.BOTTOM;
                    }
                    case DOWN: {
                        return Side.TOP;
                    }
                }
                break;
            }
            case DOWN: {
                switch (facing) {
                    case SOUTH: {
                        return Side.FRONT;
                    }
                    case WEST: {
                        return Side.RIGHT;
                    }
                    case NORTH: {
                        return Side.BACK;
                    }
                    case EAST: {
                        return Side.LEFT;
                    }
                    case DOWN: {
                        return Side.BOTTOM;
                    }
                    case UP: {
                        return Side.TOP;
                    }
                }
            }
        }
        return null;
    }

    protected Direction getPlayerDirectionFacing(Player player, boolean allowVertical) {
        Direction[] playerFacings;
        Direction panelFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        for (Direction facing : playerFacings = Direction.m_122382_((Entity)player)) {
            if (!allowVertical && (facing == panelFacing || facing == panelFacing.m_122424_())) continue;
            return facing;
        }
        return player.m_6350_();
    }

    public boolean hasBase() {
        return !this.m_58900_().m_61138_((Property)Registration.HAS_PANEL_BASE) || (Boolean)this.m_58900_().m_61143_((Property)Registration.HAS_PANEL_BASE) != false;
    }

    @CheckForNull
    public IPanelCell getIPanelCell(PanelCellPos cellPos) {
        if (cellPos == null) {
            return null;
        }
        return this.cells.get(cellPos.getIndex());
    }

    @CheckForNull
    public Side getCellFacing(PanelCellPos cellPos) {
        if (cellPos == null) {
            return null;
        }
        return this.cellDirections.get(cellPos.getIndex());
    }

    public List<PanelCellPos> getCellPositions() {
        ArrayList<PanelCellPos> poss = new ArrayList<PanelCellPos>();
        for (Integer index : this.cells.keySet()) {
            poss.add(PanelCellPos.fromIndex(this, index));
        }
        return poss;
    }

    public int getCellCount() {
        return this.cells.size();
    }

    public void removeCell(PanelCellPos cellPos) {
        if (cellPos.getIPanelCell() != null) {
            int cellIndex = cellPos.getIndex();
            boolean isRedstoneDust = cellPos.getIPanelCell() instanceof RedstoneDust;
            cellPos.getIPanelCell().onRemove(cellPos);
            this.cellDirections.remove(cellIndex);
            this.cells.remove(cellIndex);
            BlockPos pos = cellPos.getPanelTile().m_58899_();
            cellPos.getPanelTile().m_58904_().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12442_, SoundSource.BLOCKS, 0.15f, 2.0f, false);
            try {
                this.updateNeighborCells(cellPos);
                if (isRedstoneDust) {
                    PanelCellPos above = cellPos.offset(Side.TOP);
                    PanelCellPos below = cellPos.offset(Side.BOTTOM);
                    if (above != null) {
                        this.updateNeighborCells(above);
                    }
                    if (below != null) {
                        this.updateNeighborCells(below);
                    }
                }
                this.flagVoxelShapeUpdate();
                this.flagSync();
            }
            catch (PanelOverflowException e) {
                this.handleCrash(e);
            }
        }
    }

    public void removeAllCells(@Nullable Player player) {
        Object[] indices;
        for (Object index : indices = this.cells.keySet().toArray()) {
            ((PanelBlock)this.m_58900_().m_60734_()).removeCell(PanelCellPos.fromIndex(this, (Integer)index), player);
        }
    }

    public void addCell(PanelCellPos cellPos, IPanelCell panelCell, Side facing, Player player) throws PanelOverflowException {
        int cellIndex = cellPos.getIndex();
        this.cellDirections.put(cellIndex, facing);
        this.cells.put(cellIndex, panelCell);
        BlockPos pos = cellPos.getPanelTile().m_58899_();
        cellPos.getPanelTile().m_58904_().m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12447_, SoundSource.BLOCKS, 0.15f, 2.0f, false);
        panelCell.onPlace(cellPos, player);
        this.updateNeighborCells(cellPos);
        this.flagVoxelShapeUpdate();
    }

    public boolean hasCellsOnFace(Direction direction) {
        return !this.getEdgeCellIndices(direction).isEmpty();
    }

    public void flagSync() {
        this.flagSync = true;
    }

    public void flagVoxelShapeUpdate() {
        this.voxelShape = null;
    }

    public VoxelShape getVoxelShape() {
        if (this.voxelShape == null) {
            this.updateVoxelShape();
        }
        return this.voxelShape;
    }

    private void updateVoxelShape() {
        TinyRedstone.LOGGER.debug("updating voxel shape at " + this.m_58899_().m_123344_() + ": " + (this.f_58857_.f_46443_ ? "client" : "server"));
        if (this.isCovered()) {
            VoxelShape coverShape = this.panelCover.getShape();
            if (Shapes.m_83144_().equals(coverShape) || this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_) == Direction.DOWN) {
                this.voxelShape = coverShape;
            } else {
                VoxelShape[] buff = new VoxelShape[]{Shapes.m_83040_()};
                switch ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)) {
                    case UP: {
                        coverShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                            buff[0] = Shapes.m_83048_((double)minX, (double)(1.0 - maxY), (double)(1.0 - maxZ), (double)maxX, (double)(1.0 - minY), (double)(1.0 - minZ));
                        });
                        this.voxelShape = buff[0];
                        break;
                    }
                    case NORTH: {
                        coverShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                            buff[0] = Shapes.m_83048_((double)minX, (double)(1.0 - maxZ), (double)minY, (double)maxX, (double)(1.0 - minZ), (double)maxY);
                        });
                        this.voxelShape = buff[0];
                        break;
                    }
                    case EAST: {
                        coverShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                            buff[0] = Shapes.m_83048_((double)(1.0 - maxY), (double)minX, (double)minZ, (double)(1.0 - minY), (double)maxX, (double)maxZ);
                        });
                        this.voxelShape = buff[0];
                        break;
                    }
                    case SOUTH: {
                        coverShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                            buff[0] = Shapes.m_83048_((double)minX, (double)minZ, (double)(1.0 - maxY), (double)maxX, (double)maxZ, (double)(1.0 - minY));
                        });
                        this.voxelShape = buff[0];
                        break;
                    }
                    case WEST: {
                        coverShape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                            buff[0] = Shapes.m_83048_((double)minY, (double)(1.0 - maxX), (double)minZ, (double)maxY, (double)(1.0 - minX), (double)maxZ);
                        });
                        this.voxelShape = buff[0];
                    }
                }
            }
        } else {
            if (this.hasBase()) {
                switch ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)) {
                    case UP: {
                        this.voxelShape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                        break;
                    }
                    case NORTH: {
                        this.voxelShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
                        break;
                    }
                    case EAST: {
                        this.voxelShape = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                        break;
                    }
                    case SOUTH: {
                        this.voxelShape = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
                        break;
                    }
                    case WEST: {
                        this.voxelShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
                        break;
                    }
                    default: {
                        this.voxelShape = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
                        break;
                    }
                }
            } else {
                this.voxelShape = this.cells.isEmpty() || this.isCrashed() ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.1, (double)16.0) : Shapes.m_83040_();
            }
            for (Integer index : this.cells.keySet()) {
                PanelCellPos cellPos = PanelCellPos.fromIndex(this, index);
                VoxelShape cellVoxelShape = this.getCellVoxelShape(cellPos);
                if (cellVoxelShape == null) continue;
                this.voxelShape = Shapes.m_83110_((VoxelShape)this.voxelShape, (VoxelShape)cellVoxelShape);
            }
        }
    }

    @CheckForNull
    public VoxelShape getCellVoxelShape(PanelCellPos cellPos) {
        IPanelCell cell;
        if (cellPos != null && (cell = cellPos.getIPanelCell()) != null) {
            PanelCellVoxelShape[] cellShapes;
            VoxelShape voxelShape = Shapes.m_83040_();
            Direction thisFacing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            block7: for (PanelCellVoxelShape cellShape : cellShapes = cell.getShapes(cellPos)) {
                float rowStart = (float)cellPos.getRow() * 2.0f + (float)cellShape.getPoint1().f_86214_ * 2.0f;
                float rowEnd = (float)cellPos.getRow() * 2.0f + (float)cellShape.getPoint2().f_86214_ * 2.0f;
                float columnStart = (float)cellPos.getColumn() * 2.0f + (float)cellShape.getPoint1().f_86216_ * 2.0f;
                float columnEnd = (float)cellPos.getColumn() * 2.0f + (float)cellShape.getPoint2().f_86216_ * 2.0f;
                float levelStart = (float)(this.hasBase() ? 2 : 0) + (float)cellPos.getLevel() * 2.0f + (float)cellShape.getPoint1().f_86215_ * 2.0f;
                float levelEnd = (float)(this.hasBase() ? 2 : 0) + (float)cellPos.getLevel() * 2.0f + (float)cellShape.getPoint2().f_86215_ * 2.0f;
                switch (thisFacing) {
                    case UP: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)rowStart, (double)(16.0f - levelEnd), (double)(16.0f - columnEnd), (double)rowEnd, (double)(16.0f - levelStart), (double)(16.0f - columnStart)));
                        continue block7;
                    }
                    case NORTH: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)rowStart, (double)(16.0f - columnEnd), (double)levelStart, (double)rowEnd, (double)(16.0f - columnStart), (double)levelEnd));
                        continue block7;
                    }
                    case EAST: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)(16.0f - levelEnd), (double)rowStart, (double)columnStart, (double)(16.0f - levelStart), (double)rowEnd, (double)columnEnd));
                        continue block7;
                    }
                    case SOUTH: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)rowStart, (double)columnStart, (double)(16.0f - levelEnd), (double)rowEnd, (double)columnEnd, (double)(16.0f - levelStart)));
                        continue block7;
                    }
                    case WEST: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)levelStart, (double)(16.0f - rowEnd), (double)columnStart, (double)levelEnd, (double)(16.0f - rowStart), (double)columnEnd));
                        continue block7;
                    }
                    default: {
                        voxelShape = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)Block.m_49796_((double)rowStart, (double)levelStart, (double)columnStart, (double)rowEnd, (double)levelEnd, (double)columnEnd));
                    }
                }
            }
            return voxelShape;
        }
        return null;
    }

    public void onBlockDestroy() {
        for (Integer index : this.cells.keySet()) {
            PanelCellPos pos = PanelCellPos.fromIndex(this, index);
            this.cells.get(index).onRemove(pos);
        }
    }

    public BlockHitResult getPlayerCollisionHitResult(Player player) {
        float xRotation = player.m_146909_();
        float yRotation = player.m_146908_();
        Vec3 eyePosition = player.m_146892_();
        float v = -Mth.m_14089_((float)(-xRotation * ((float)Math.PI / 180)));
        float x = Mth.m_14031_((float)(-yRotation * ((float)Math.PI / 180) - (float)Math.PI)) * v;
        float y = Mth.m_14031_((float)(-xRotation * ((float)Math.PI / 180)));
        float z = Mth.m_14089_((float)(-yRotation * ((float)Math.PI / 180) - (float)Math.PI)) * v;
        double reachDistance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 vec31 = eyePosition.m_82520_((double)x * reachDistance, (double)y * reachDistance, (double)z * reachDistance);
        return this.f_58857_.m_45547_(new ClipContext(eyePosition, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)player));
    }
}

