/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class Lever
implements IPanelCell,
IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_LEVER = new ResourceLocation("minecraft", "block/lever");
    public static ResourceLocation TEXTURE_COBBLESTONE = new ResourceLocation("minecraft", "block/cobblestone");
    private boolean active = false;
    private Side baseSide = Side.BOTTOM;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        TextureAtlasSprite sprite_cobble = RenderHelper.getSprite(TEXTURE_COBBLESTONE);
        TextureAtlasSprite sprite_lever = RenderHelper.getSprite(TEXTURE_LEVER);
        float lu0 = sprite_lever.m_118409_();
        float lu1 = sprite_lever.m_118410_();
        float lv0 = sprite_lever.m_118411_();
        float lv1 = sprite_lever.m_118412_();
        float lhu0 = lu0 + (lu1 - lu0) * 7.0f / 16.0f;
        float lhu1 = lhu0 + (lu1 - lu0) * 2.0f / 16.0f;
        float lhv0 = lv0 + (lv1 - lv0) * 6.0f / 16.0f;
        float lhv1 = lv1;
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        matrixStack.m_85836_();
        float x1 = 0.3125f;
        float x2 = 0.6875f;
        float y1 = 0.25f;
        float y2 = 0.75f;
        float w = 0.375f;
        float d = 0.5f;
        float h = 0.1875f;
        if (this.baseSide == Side.FRONT) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrixStack.m_85837_(0.0, 0.0, (double)(h - 1.0f));
        } else if (this.baseSide == Side.TOP) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85837_(0.0, -1.0, (double)(h - 1.0f));
        } else {
            matrixStack.m_85837_(0.0, 0.0, (double)h);
        }
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, sprite_cobble, combinedLight, alpha);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, (double)(-h), (double)(-y1));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, (double)(1.0f - x1));
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, d, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, (double)d);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, w, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, (double)w);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, d, 0.0f, h, sprite_cobble, combinedLight, alpha);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(60.0f));
        matrixStack.m_85837_(0.0, 0.03125, 0.0);
        matrixStack.m_85849_();
        x1 = 0.4375f;
        x2 = 0.5625f;
        y1 = 0.0f;
        y2 = 0.625f;
        if (this.baseSide == Side.FRONT) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            matrixStack.m_85837_(0.0, 0.40625, (double)(h / 2.0f - 1.0f));
        } else if (this.baseSide == Side.TOP) {
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85837_(0.0, -0.59375, (double)(h / 2.0f - 1.0f));
        } else {
            matrixStack.m_85837_(0.0, 0.40625, (double)(h / 2.0f));
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(this.active ? 45.0f : 135.0f));
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, lhu1, lhu0, lhv1, lhv0, combinedLight, -1, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, lhu1, lhu0, lhv1, lhv0, combinedLight, -1, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, lhu1, lhu0, lhv1, lhv0, combinedLight, -1, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_((double)(-x1), 0.0, (double)x2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, y1, y2, lhu1, lhu0, lhv1, lhv0, combinedLight, -1, alpha);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        matrixStack.m_85837_(0.0, (double)(-x1), (double)y2);
        RenderHelper.drawRectangle(builder, matrixStack, x1, x2, x1, x2, lhu1, lhu0, lhv0 + (lv1 - lv0) * 2.0f / 16.0f, lhv0, combinedLight, -1, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.active && outputDirection != this.baseSide.getOpposite() ? 15 : 0;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.active && outputDirection == this.baseSide ? 15 : 0;
    }

    @Override
    public boolean isIndependentState() {
        return true;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public Side getBaseSide() {
        return this.baseSide;
    }

    @Override
    public void setBaseSide(Side side) {
        this.baseSide = side;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        PanelTile panelTile = cellPos.getPanelTile();
        panelTile.m_58904_().m_7785_((double)panelTile.m_58899_().m_123341_(), (double)panelTile.m_58899_().m_123342_(), (double)panelTile.m_58899_().m_123343_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 0.25f, 2.0f, false);
        this.active = !this.active;
        return true;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("active", this.active);
        nbt.m_128359_("baseSide", this.baseSide.name());
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.active = compoundNBT.m_128471_("active");
        this.baseSide = compoundNBT.m_128461_("baseSide").length() > 0 ? Side.valueOf(compoundNBT.m_128461_("baseSide")) : Side.BOTTOM;
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("State", this.active ? "On" : "Off");
        overlayBlockInfo.setPowerOutput(0);
    }

    @Override
    public PanelCellVoxelShape getShape() {
        if (this.baseSide == Side.BOTTOM) {
            return PanelCellVoxelShape.BUTTONSHAPE;
        }
        if (this.baseSide == Side.TOP) {
            return PanelCellVoxelShape.BUTTONSHAPE_TOP;
        }
        return PanelCellVoxelShape.BUTTONSHAPE_FRONT;
    }
}

