/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class RedstoneLamp
extends TinyBlock
implements IPanelCell {
    private boolean lit = false;
    public static ResourceLocation TEXTURE_REDSTONE_LAMP = new ResourceLocation("minecraft", "block/redstone_lamp");
    public static ResourceLocation TEXTURE_REDSTONE_LAMP_ON = new ResourceLocation("minecraft", "block/redstone_lamp_on");

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = this.lit ? RenderHelper.getSprite(TEXTURE_REDSTONE_LAMP_ON) : RenderHelper.getSprite(TEXTURE_REDSTONE_LAMP);
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean change = super.neighborChanged(cellPos);
        if (this.weakSignalStrength + this.strongSignalStrength > 0 || (frontNeighbor != null ? frontNeighbor.getWeakRsOutput() : 0) + (rightNeighbor != null ? rightNeighbor.getWeakRsOutput() : 0) + (backNeighbor != null ? backNeighbor.getWeakRsOutput() : 0) + (leftNeighbor != null ? leftNeighbor.getWeakRsOutput() : 0) + (topNeighbor != null ? topNeighbor.getWeakRsOutput() : 0) + (bottomNeighbor != null ? bottomNeighbor.getWeakRsOutput() : 0) > 0) {
            if (!this.lit) {
                this.lit = true;
                return true;
            }
        } else if (this.lit) {
            this.lit = false;
            return true;
        }
        return change;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        nbt.m_128379_("lit", this.lit);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        super.readNBT(compoundNBT);
        this.lit = compoundNBT.m_128471_("lit");
    }

    @Override
    public int lightOutput() {
        return this.lit ? 1 : 0;
    }
}

