/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelCellVoxelShape;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.Comparator;
import com.dannyandson.tinyredstone.blocks.panelcells.Torch;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;

public class Repeater
implements IPanelCell,
IPanelCellInfoProvider {
    protected boolean input = false;
    protected boolean output = false;
    protected boolean locked = false;
    private int onPending = -1;
    private int offPending = -1;
    protected Integer ticks = 2;
    public static ResourceLocation TEXTURE_REPEATER_ON = new ResourceLocation("tinyredstone", "block/panel_repeater_on");
    public static ResourceLocation TEXTURE_REPEATER_OFF = new ResourceLocation("tinyredstone", "block/panel_repeater_off");

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_repeater = this.getRepeaterTexture();
        TextureAtlasSprite sprite_torch_head = RenderHelper.getSprite(Torch.TEXTURE_TORCH_TOP_ON);
        if (!this.output) {
            sprite_torch_head = RenderHelper.getSprite(Torch.TEXTURE_TORCH_TOP_OFF);
        }
        if (this.locked) {
            sprite_torch_head = RenderHelper.getSprite(new ResourceLocation("minecraft", "block/bedrock"));
        }
        float tU0 = sprite_torch_head.m_118409_();
        float tU1 = tU0 + (sprite_torch_head.m_118410_() - tU0) / 8.0f;
        float tV0 = sprite_torch_head.m_118411_();
        float tV1 = tV0 + (sprite_torch_head.m_118412_() - tV0) / 8.0f;
        matrixStack.m_85837_(0.0, 0.0, 0.25);
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-1.0, -1.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite_repeater, combinedLight, alpha);
        matrixStack.m_85849_();
        if (this.ticks > 8) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 0.01);
            RenderHelper.drawRectangle(builder, matrixStack, 0.25f, 0.75f, 0.125f, 0.25f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.125);
        RenderHelper.drawRectangle(builder, matrixStack, 0.4375f, 0.5625f, 0.75f, 0.875f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        float torch2Y = this.ticks < 8 ? 0.75f - this.ticks.floatValue() * 0.0625f : 0.25f;
        RenderHelper.drawRectangle(builder, matrixStack, 0.4375f, 0.5625f, torch2Y - 0.125f, torch2Y, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, -0.25, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.4375, 0.25, -0.75);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85837_(0.0, 0.0, 0.875 - (double)torch2Y);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.75, 0.25, -0.4375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85837_((double)torch2Y - 0.875, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.4375, 0.25, -0.125);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85837_(0.0, 0.0, (double)torch2Y - 0.875);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 0.25f, sprite, combinedLight, alpha);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.125, 0.25, -0.4375);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85837_(0.875 - (double)torch2Y, 0.0, 0.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 0.125f, 0.0f, 0.125f, tU0, tU1, tV0, tV1, combinedLight, -1, alpha);
        matrixStack.m_85849_();
    }

    protected TextureAtlasSprite getRepeaterTexture() {
        if (this.output) {
            return RenderHelper.getSprite(TEXTURE_REPEATER_ON);
        }
        return RenderHelper.getSprite(TEXTURE_REPEATER_OFF);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        if (backNeighbor != null && backNeighbor.getWeakRsOutput() > 0 && !this.input) {
            this.input = true;
            if (this.offPending == 1) {
                this.onPending = this.ticks;
            }
        } else if ((backNeighbor == null || backNeighbor.getWeakRsOutput() == 0) && this.input) {
            this.input = false;
        }
        boolean wasLocked = this.locked;
        boolean bl = this.locked = leftNeighbor != null && leftNeighbor.getStrongRsOutput() > 0 && (leftNeighbor.getNeighborIPanelCell() instanceof Repeater || leftNeighbor.getNeighborIPanelCell() instanceof Comparator || leftNeighbor.getNeighborBlockState() != null && (leftNeighbor.getNeighborBlockState().m_60734_() == Blocks.f_50146_ || leftNeighbor.getNeighborBlockState().m_60734_() == Blocks.f_50328_)) || rightNeighbor != null && rightNeighbor.getStrongRsOutput() > 0 && (rightNeighbor.getNeighborIPanelCell() instanceof Repeater || rightNeighbor.getNeighborIPanelCell() instanceof Comparator || rightNeighbor.getNeighborBlockState() != null && (rightNeighbor.getNeighborBlockState().m_60734_() == Blocks.f_50146_ || rightNeighbor.getNeighborBlockState().m_60734_() == Blocks.f_50328_));
        if (wasLocked && !this.locked && this.output != this.input) {
            if (this.input) {
                this.onPending = this.ticks;
            } else {
                this.offPending = this.ticks;
            }
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.getStrongRsOutput(outputDirection);
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        if (this.output && outputDirection == Side.FRONT) {
            return 15;
        }
        return 0;
    }

    @Override
    public boolean needsSolidBase() {
        return true;
    }

    @Override
    public boolean canAttachToBaseOnSide(Side side) {
        return side == Side.BOTTOM;
    }

    @Override
    public Side getBaseSide() {
        return Side.BOTTOM;
    }

    @Override
    public boolean tick(PanelCellPos cellPos) {
        if (this.input != this.output) {
            if (this.input && this.onPending == -1) {
                this.onPending = this.ticks;
            }
            if (!this.input && this.offPending == -1) {
                this.offPending = this.ticks;
            }
        }
        if (this.onPending >= 0) {
            --this.onPending;
        }
        if (this.offPending >= 0) {
            --this.offPending;
        }
        if (this.onPending == 0 && !this.locked) {
            this.output = true;
            this.offPending = this.input ? -1 : this.ticks;
            return true;
        }
        if (this.offPending == 0 && !this.locked && (!this.input || this.output && this.onPending > -1)) {
            if (this.output && this.onPending > -1) {
                this.onPending = this.ticks;
            }
            this.output = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        if (this.ticks < 8) {
            this.ticks = this.ticks + 2;
            return true;
        }
        this.ticks = 2;
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("output", this.output);
        nbt.m_128379_("input", this.input);
        nbt.m_128379_("locked", this.locked);
        nbt.m_128405_("offPending", this.offPending);
        nbt.m_128405_("onPending", this.onPending);
        nbt.m_128405_("ticks", this.ticks.intValue());
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.output = compoundNBT.m_128471_("output");
        this.input = compoundNBT.m_128471_("input");
        this.locked = compoundNBT.m_128471_("locked");
        this.ticks = compoundNBT.m_128451_("ticks");
        this.offPending = compoundNBT.m_128451_("offPending");
        this.onPending = compoundNBT.m_128451_("onPending");
    }

    public Integer getTicks() {
        return this.ticks;
    }

    public void setTicks(Integer ticks) {
        this.ticks = ticks < 0 ? Integer.valueOf(0) : (ticks > (Integer)Config.SUPER_REPEATER_MAX.get() * 2 ? Integer.valueOf((Integer)Config.SUPER_REPEATER_MAX.get() * 2) : ticks);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Delay", this.ticks / 2 + " ticks");
        if (this.locked) {
            overlayBlockInfo.addInfo("Locked");
        }
    }

    @Override
    public PanelCellVoxelShape getShape() {
        return PanelCellVoxelShape.QUARTERCELLSLAB;
    }
}

