/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IColorablePanelCell;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TinyBlock
implements IPanelCell,
IColorablePanelCell,
IPanelCellInfoProvider {
    public static final ResourceLocation TEXTURE_GRASS_BLOCK_TOP = new ResourceLocation("tinyredstone", "block/grass_block_top");
    public static final ResourceLocation TEXTURE_TINY_BLOCK = new ResourceLocation("minecraft", "block/white_wool");
    protected int weakSignalStrength = 0;
    protected int strongSignalStrength = 0;
    protected int color = -1;
    protected ResourceLocation madeFrom;
    protected TextureAtlasSprite sprite_top;
    protected TextureAtlasSprite sprite_front;
    protected TextureAtlasSprite sprite_right;
    protected TextureAtlasSprite sprite_back;
    protected TextureAtlasSprite sprite_left;
    protected TextureAtlasSprite sprite_bottom;

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        if (this.sprite_top == null) {
            if (this.madeFrom != null) {
                this.sprite_top = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.TOP);
                this.sprite_front = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.FRONT);
                this.sprite_right = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.RIGHT);
                this.sprite_back = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BACK);
                this.sprite_left = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.LEFT);
                this.sprite_bottom = Registration.TINY_BLOCK_OVERRIDES.getSprite(this.madeFrom, Side.BOTTOM);
            } else {
                this.sprite_left = this.sprite_bottom = RenderHelper.getSprite(TEXTURE_TINY_BLOCK);
                this.sprite_back = this.sprite_bottom;
                this.sprite_right = this.sprite_bottom;
                this.sprite_front = this.sprite_bottom;
                this.sprite_top = this.sprite_bottom;
            }
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-1.0, -1.0, 1.0);
        RenderHelper.drawCube(matrixStack, builder, this.sprite_top, this.sprite_front, this.sprite_right, this.sprite_back, this.sprite_left, this.sprite_bottom, combinedLight, this.color, alpha);
    }

    @Override
    public boolean onPlace(PanelCellPos cellPos, Player player) {
        CompoundTag itemNBT;
        CompoundTag madeFromTag;
        ItemStack stack = ItemStack.f_41583_;
        if (player.m_7655_() != null) {
            stack = player.m_21120_(player.m_7655_());
        }
        if (stack == ItemStack.f_41583_) {
            stack = player.m_21205_();
        }
        if (stack.m_41782_() && (madeFromTag = (itemNBT = stack.m_41783_()).m_128469_("made_from")).m_128441_("namespace")) {
            this.madeFrom = new ResourceLocation(madeFromTag.m_128461_("namespace"), madeFromTag.m_128461_("path"));
        }
        return IPanelCell.super.onPlace(cellPos, player);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        int weak = 0;
        int strong = 0;
        if (frontNeighbor != null) {
            if (frontNeighbor.powerDrops()) {
                weak = frontNeighbor.getWeakRsOutput();
            } else if (!(frontNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = frontNeighbor.getStrongRsOutput();
            }
        }
        if (rightNeighbor != null) {
            if (rightNeighbor.powerDrops()) {
                weak = Math.max(weak, rightNeighbor.getWeakRsOutput());
            } else if (!(rightNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, rightNeighbor.getStrongRsOutput());
            }
        }
        if (backNeighbor != null) {
            if (backNeighbor.powerDrops()) {
                weak = Math.max(weak, backNeighbor.getWeakRsOutput());
            } else if (!(backNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, backNeighbor.getStrongRsOutput());
            }
        }
        if (leftNeighbor != null) {
            if (leftNeighbor.powerDrops()) {
                weak = Math.max(weak, leftNeighbor.getWeakRsOutput());
            } else if (!(leftNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, leftNeighbor.getStrongRsOutput());
            }
        }
        if (topNeighbor != null) {
            if (topNeighbor.powerDrops()) {
                weak = Math.max(weak, topNeighbor.getWeakRsOutput());
            } else if (!(topNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, topNeighbor.getStrongRsOutput());
            }
        }
        if (bottomNeighbor != null) {
            if (bottomNeighbor.powerDrops()) {
                weak = Math.max(weak, bottomNeighbor.getWeakRsOutput());
            } else if (!(bottomNeighbor.getNeighborIPanelCell() instanceof TinyBlock)) {
                strong = Math.max(strong, bottomNeighbor.getStrongRsOutput());
            }
        }
        if ((weak = Math.max(weak, strong)) != this.weakSignalStrength || strong != this.strongSignalStrength) {
            this.weakSignalStrength = weak;
            this.strongSignalStrength = strong;
            return true;
        }
        return false;
    }

    @Override
    public int getWeakRsOutput(Side outputDirection) {
        return this.weakSignalStrength;
    }

    @Override
    public int getStrongRsOutput(Side outputDirection) {
        return this.strongSignalStrength;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("strong", this.strongSignalStrength);
        nbt.m_128405_("weak", this.weakSignalStrength);
        nbt.m_128405_("color", this.color);
        if (this.madeFrom != null) {
            nbt.m_128359_("made_from_namespace", this.madeFrom.m_135827_());
            nbt.m_128359_("made_from_path", this.madeFrom.m_135815_());
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        this.strongSignalStrength = compoundNBT.m_128451_("strong");
        this.weakSignalStrength = compoundNBT.m_128451_("weak");
        this.color = compoundNBT.m_128451_("color");
        if (compoundNBT.m_128441_("made_from_namespace")) {
            this.madeFrom = new ResourceLocation(compoundNBT.m_128461_("made_from_namespace"), compoundNBT.m_128461_("made_from_path"));
        }
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.setPowerOutput(this.weakSignalStrength);
    }

    @Override
    public CompoundTag getItemTag() {
        if (this.madeFrom != null) {
            CompoundTag madeFromTag = new CompoundTag();
            madeFromTag.m_128359_("namespace", this.madeFrom.m_135827_());
            madeFromTag.m_128359_("path", this.madeFrom.m_135815_());
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128365_("made_from", (Tag)madeFromTag);
            return itemTag;
        }
        return null;
    }
}

