/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.compat.hwyla;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.compat.OverlayBlockInfoMode;
import com.dannyandson.tinyredstone.compat.hwyla.PanelProvider;
import java.util.ArrayList;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class OverlayBlockInfo
implements IOverlayBlockInfo {
    private final ITooltip tooltip;
    private final boolean sneaking;
    protected int power = -1;

    protected OverlayBlockInfo(ITooltip tooltip, boolean sneaking) {
        this.tooltip = tooltip;
        this.sneaking = sneaking;
    }

    @Override
    public OverlayBlockInfoMode getMode() {
        if (this.sneaking) {
            return OverlayBlockInfoMode.EXTENDED;
        }
        return OverlayBlockInfoMode.NORMAL;
    }

    @Override
    public void setPowerOutput(int power) {
        this.power = power;
    }

    @Override
    public void addText(String text) {
        this.tooltip.add(this.tooltip.getElementHelper().text(Component.m_130674_((String)text)));
    }

    @Override
    public void addText(ItemStack itemStack, String text) {
        IElementHelper helper = this.tooltip.getElementHelper();
        ArrayList<IElement> elements = new ArrayList<IElement>();
        elements.add(helper.item(itemStack).tag(PanelProvider.RENDER_ITEM_INLINE));
        elements.add(helper.text(Component.m_130674_((String)text)).tag(PanelProvider.RENDER_STRING));
        this.tooltip.add(elements);
    }

    @Override
    public void addText(String label, String text) {
        this.tooltip.add(this.tooltip.getElementHelper().text(Component.m_130674_((String)(label + ": " + text))).tag(PanelProvider.RENDER_STRING));
    }

    @Override
    public void addText(ItemStack itemStack, String label, String text) {
        IElementHelper helper = this.tooltip.getElementHelper();
        ArrayList<IElement> elements = new ArrayList<IElement>();
        elements.add(helper.item(itemStack).tag(PanelProvider.RENDER_ITEM_INLINE));
        elements.add(helper.text(Component.m_130674_((String)(label + ": " + text))).tag(PanelProvider.RENDER_STRING));
        this.tooltip.add(elements);
    }

    @Override
    public void addInfo(String text) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("string", text);
        this.tooltip.add(Component.m_130674_((String)text), PanelProvider.RENDER_INFO_STRING);
    }
}

