/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.compat.hwyla;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.compat.CompatHandler;
import com.dannyandson.tinyredstone.compat.hwyla.OverlayBlockInfo;
import java.util.ArrayList;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

@WailaPlugin(value="tinyredstone")
public class PanelProvider
implements IWailaPlugin,
IComponentProvider {
    static final ResourceLocation RENDER_STRING = new ResourceLocation("string");
    static final ResourceLocation RENDER_ITEM_INLINE = new ResourceLocation("item_inline");
    static final ResourceLocation RENDER_INFO_STRING = new ResourceLocation("info_string");

    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, PanelBlock.class);
    }

    private boolean show(Player playerEntity) {
        switch ((Integer)Config.DISPLAY_MODE.get()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return playerEntity.m_6047_();
            }
            case 3: {
                return CompatHandler.isMeasuringDevice(playerEntity.m_21205_().m_41720_());
            }
            case 4: {
                return CompatHandler.isTinyComponent(playerEntity.m_21205_().m_41720_());
            }
        }
        return true;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() != null) {
            BlockPos pos = accessor.getPosition();
            BlockEntity tileEntity = accessor.getLevel().m_7702_(pos);
            if (tileEntity instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)tileEntity;
                if (this.show(accessor.getPlayer())) {
                    IElementHelper helper = tooltip.getElementHelper();
                    if (!panelTile.isCovered()) {
                        BlockHitResult rtr = new BlockHitResult(((BlockHitResult)accessor.getHitResult()).m_82450_(), accessor.getSide(), pos, true);
                        PosInPanelCell posInPanelCell = PosInPanelCell.fromHitVec(panelTile, pos, rtr);
                        if (posInPanelCell != null) {
                            IPanelCell panelCell = posInPanelCell.getIPanelCell();
                            if (panelCell != null) {
                                Side sideHit;
                                int power;
                                boolean handled = false;
                                Item item = PanelBlock.getItemByIPanelCell(panelCell.getClass());
                                ArrayList<IElement> elements = new ArrayList<IElement>();
                                elements.add(helper.text((Component)new TranslatableComponent(item.m_5524_())).tag(RENDER_STRING));
                                tooltip.add(elements);
                                if (panelCell instanceof IPanelCellInfoProvider) {
                                    OverlayBlockInfo overlayBlockInfo = new OverlayBlockInfo(tooltip, accessor.getPlayer().m_6047_());
                                    ((IPanelCellInfoProvider)((Object)panelCell)).addInfo(overlayBlockInfo, panelTile, posInPanelCell);
                                    if (overlayBlockInfo.power > -1) {
                                        handled = true;
                                        if (overlayBlockInfo.power > 0) {
                                            PanelProvider.showRedstonePower(tooltip, helper, overlayBlockInfo.power);
                                        }
                                    }
                                }
                                if (!handled && (power = panelCell.getWeakRsOutput(sideHit = panelTile.getPanelCellSide((PanelCellPos)posInPanelCell, panelTile.getSideFromDirection(accessor.getSide())))) > 0) {
                                    PanelProvider.showRedstonePower(tooltip, helper, power);
                                }
                            }
                        } else {
                            PanelProvider.showBlockRedstonePower(tooltip, accessor.getLevel(), pos, accessor.getSide(), helper);
                        }
                    } else {
                        PanelProvider.showBlockRedstonePower(tooltip, accessor.getLevel(), pos, accessor.getSide(), helper);
                    }
                }
            }
        }
    }

    private static void showBlockRedstonePower(ITooltip tooltip, Level world, BlockPos pos, Direction sideHit, IElementHelper helper) {
        PanelProvider.showRedstonePower(tooltip, helper, world.m_46681_(pos, sideHit.m_122424_()));
    }

    private static void showRedstonePower(ITooltip tooltip, IElementHelper helper, int power) {
        if (power > 0) {
            ArrayList<IElement> elements = new ArrayList<IElement>();
            elements.add(helper.text(Component.m_130674_((String)"Power:")).tag(RENDER_STRING));
            elements.add(helper.text(Component.m_130674_((String)(" " + power))).tag(RENDER_INFO_STRING));
            tooltip.add(elements);
        }
    }
}

