/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.PushChopperOutputType;
import com.dannyandson.tinyredstone.network.ValidTinyBlockCacheSync;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;

public class ChopperMenu
extends AbstractContainerMenu {
    public static List<Material> solidMaterials = Arrays.asList(Material.f_76320_, Material.f_76278_, Material.f_76279_, Material.f_76316_, Material.f_76313_, Material.f_76317_, Material.f_76314_, Material.f_76315_, Material.f_76280_, Material.f_76272_, Material.f_76321_, Material.f_76318_);
    public static List<Material> transparentMaterials = Arrays.asList(Material.f_76275_, Material.f_76276_);
    private final Container container;
    private final ResultContainer resultContainer;
    private Slot inputSlot;
    private Slot outputSlot;
    private String itemType = "Tiny Block";

    public static ChopperMenu createChopperMenu(int containerId, Inventory playerInventory) {
        return ChopperMenu.createChopperMenu(containerId, playerInventory, (Container)new SimpleContainer(1));
    }

    public static ChopperMenu createChopperMenu(int containerId, Inventory playerInventory, Container inventory) {
        return new ChopperMenu(containerId, playerInventory, inventory);
    }

    protected ChopperMenu(int containerId, Inventory playerInventory, Container container) {
        super((MenuType)Registration.CUTTER_MENU_TYPE.get(), containerId);
        ChopperMenu.m_38869_((Container)container, (int)1);
        this.container = container;
        if (container instanceof ChopperBlockEntity) {
            ChopperBlockEntity chopperBlockEntity = (ChopperBlockEntity)container;
            chopperBlockEntity.setCutterMenu(this);
            chopperBlockEntity.setItemType(this.itemType);
            this.resultContainer = chopperBlockEntity.getResultContainer();
        } else {
            this.resultContainer = new ResultContainer();
        }
        container.m_5856_(playerInventory.f_35978_);
        int leftCol = 12;
        int ySize = 184;
        this.inputSlot = this.m_38897_(new Slot(container, 0, 30, 44));
        this.outputSlot = this.m_38897_(new Slot((Container)this.resultContainer, 1, 138, 44){

            public boolean m_5857_(ItemStack p_40362_) {
                return false;
            }

            public void m_142406_(Player player, ItemStack itemStack) {
                itemStack.m_41678_(player.f_19853_, player, itemStack.m_41613_());
                ItemStack itemstack = ChopperMenu.this.inputSlot.m_6201_(1);
                if (!itemstack.m_41619_()) {
                    ChopperMenu.this.setupResultSlot();
                }
                super.m_142406_(player, itemStack);
            }
        });
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
        this.setupResultSlot();
    }

    void setupResultSlot() {
        if (this.inputSlot != null) {
            ItemStack inputStack = this.inputSlot.m_7993_();
            ItemStack outputStack = ItemStack.f_41583_;
            Item item = inputStack.m_41720_();
            Item item2 = inputStack.m_41720_();
            if (item2 instanceof BlockItem) {
                ChopperBlockEntity chopperBlockEntity;
                boolean isFullBlock;
                BlockItem blockItem = (BlockItem)item2;
                Block inputBlock = blockItem.m_40614_();
                BlockState inputBlockState = inputBlock.m_49966_();
                Material material = inputBlock.m_49966_().m_60767_();
                Container container = this.container;
                if (container instanceof ChopperBlockEntity && (isFullBlock = inputBlockState.m_60838_((BlockGetter)(chopperBlockEntity = (ChopperBlockEntity)container).m_58904_(), chopperBlockEntity.m_58899_())) && !inputBlockState.m_60803_() && !inputBlockState.m_155947_()) {
                    ResourceLocation inputRegistryName = inputBlock.getRegistryName();
                    if (!Registration.TINY_BLOCK_OVERRIDES.hasUsableTexture(inputRegistryName)) {
                        if (!chopperBlockEntity.m_58904_().f_46443_) {
                            ModNetworkHandler.sendToNearestClient(new ValidTinyBlockCacheSync(chopperBlockEntity.m_58899_(), inputRegistryName), chopperBlockEntity.m_58904_(), chopperBlockEntity.m_58899_());
                        }
                    } else if (inputBlock.getRegistryName() != null) {
                        CompoundTag madeFromTag = new CompoundTag();
                        madeFromTag.m_128359_("namespace", inputBlock.getRegistryName().m_135827_());
                        madeFromTag.m_128359_("path", inputBlock.getRegistryName().m_135815_());
                        if (this.getItemType().equals("Dark Cover")) {
                            outputStack = ((Item)Registration.PANEL_COVER_DARK.get()).m_7968_();
                            outputStack.m_41764_(2);
                            outputStack.m_41700_("made_from", (Tag)madeFromTag);
                        } else if (this.getItemType().equals("Light Cover")) {
                            outputStack = ((Item)Registration.PANEL_COVER_LIGHT.get()).m_7968_();
                            outputStack.m_41764_(2);
                            outputStack.m_41700_("made_from", (Tag)madeFromTag);
                        } else if (solidMaterials.contains(material)) {
                            outputStack = ((Item)Registration.TINY_SOLID_BLOCK.get()).m_7968_();
                            outputStack.m_41764_(8);
                            if (!inputBlock.getRegistryName().toString().equals("minecraft:white_wool")) {
                                outputStack.m_41700_("made_from", (Tag)madeFromTag);
                            }
                        } else if (transparentMaterials.contains(material)) {
                            outputStack = ((Item)Registration.TINY_TRANSPARENT_BLOCK.get()).m_7968_();
                            outputStack.m_41764_(8);
                            if (!inputBlock.getRegistryName().toString().equals("minecraft:glass")) {
                                outputStack.m_41700_("made_from", (Tag)madeFromTag);
                            }
                        }
                    }
                }
            }
            this.outputSlot.m_5852_(outputStack);
            this.m_38946_();
        }
    }

    public void m_6199_(Container container) {
        if (this.inputSlot != null) {
            ItemStack itemstack = this.inputSlot.m_7993_();
            this.setupResultSlot();
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < 2) {
                if (!this.m_38903_(itemstack1, 2, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                if (index == 1) {
                    this.outputSlot.m_142406_(player, itemstack);
                }
            } else if (!this.m_38903_(itemstack1, 0, 1, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            this.setupResultSlot();
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public String getItemType() {
        if (this.container instanceof ChopperBlockEntity) {
            return ((ChopperBlockEntity)this.container).getItemType();
        }
        return this.itemType;
    }

    public void toggleItemType(BlockPos pos) {
        if (this.itemType == "Tiny Block") {
            this.itemType = "Dark Cover";
        } else if (this.itemType == "Dark Cover") {
            this.itemType = "Light Cover";
        } else if (this.itemType == "Light Cover") {
            this.itemType = "Tiny Block";
        }
        ModNetworkHandler.sendToServer(new PushChopperOutputType(this.itemType, pos));
    }
}

