/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.items;

import com.dannyandson.tinyredstone.Config;
import com.dannyandson.tinyredstone.TinyRedstone;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelBlock;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.blocks.panelcells.TransparentBlock;
import com.dannyandson.tinyredstone.gui.BlueprintGUI;
import com.dannyandson.tinyredstone.setup.ModSetup;
import com.dannyandson.tinyredstone.setup.Registration;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Blueprint
extends Item {
    public Blueprint() {
        super(new Item.Properties().m_41491_(ModSetup.ITEM_GROUP));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flags) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("blueprint")) {
            list.add((Component)new TranslatableComponent("message.item.blueprint.full"));
            List<ItemStack> blueprintItems = Blueprint.getRequiredItemStacks(stack.m_41737_("blueprint"));
            for (ItemStack item : blueprintItems) {
                Component itemNameComponent = item.m_41786_();
                String itemName = itemNameComponent.getString();
                list.add(Component.m_130674_((String)(itemName + " : " + item.m_41613_())));
            }
        } else {
            list.add((Component)new TranslatableComponent("message.item.blueprint.empty"));
        }
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity te = context.m_43725_().m_7702_(context.m_8083_());
        PanelTile panelTile = null;
        if (te instanceof PanelTile) {
            panelTile = (PanelTile)te;
        } else if (((Boolean)Config.ALLOW_WORLD_PLACEMENT.get()).booleanValue()) {
            ItemStack itemStackCopy = context.m_43722_().m_41777_();
            BlockPlaceContext bpContext = new BlockPlaceContext(context);
            ((BlockItem)Registration.REDSTONE_PANEL_ITEM.get()).m_40576_(bpContext);
            context.m_43723_().m_21008_(context.m_43724_(), itemStackCopy);
            te = context.m_43725_().m_7702_(bpContext.m_8083_());
            if (te instanceof PanelTile) {
                panelTile = (PanelTile)te;
            }
        }
        if (panelTile != null) {
            if (context.m_43722_().m_41783_() != null && context.m_43722_().m_41783_().m_128441_("blueprint")) {
                Player player = context.m_43723_();
                if (panelTile.getCellCount() == 0 && player != null) {
                    blueprintNBT = context.m_43722_().m_41737_("blueprint");
                    List<ItemStack> items = Blueprint.getRequiredItemStacks(blueprintNBT);
                    if (player.m_7500_() || Blueprint.playerHasSufficientComponents(items, player)) {
                        try {
                            panelTile.loadCellsFromNBT(blueprintNBT);
                            panelTile.updateSide(Side.FRONT);
                            panelTile.updateSide(Side.RIGHT);
                            panelTile.updateSide(Side.BACK);
                            panelTile.updateSide(Side.LEFT);
                            panelTile.updateSide(Side.TOP);
                            panelTile.m_6596_();
                        }
                        catch (Exception e) {
                            panelTile.handleCrash(e);
                        }
                        if (!player.m_7500_()) {
                            block2: for (ItemStack item : items) {
                                int itemsToRemove = item.m_41613_();
                                for (ItemStack invStack : player.m_150109_().f_35974_) {
                                    if (Blueprint.stacksAreMatchingItem(invStack, item)) {
                                        int removeCt = Math.min(invStack.m_41613_(), itemsToRemove);
                                        invStack.m_41764_(invStack.m_41613_() - removeCt);
                                        itemsToRemove -= removeCt;
                                    }
                                    if (itemsToRemove != 0) continue;
                                    continue block2;
                                }
                            }
                        }
                    }
                    panelTile.removeOutOfRange(player);
                }
            } else {
                CompoundTag nbt = new CompoundTag();
                blueprintNBT = panelTile.saveToNbt(new CompoundTag());
                nbt.m_128405_("CustomModelData", 1);
                nbt.m_128365_("blueprint", (Tag)blueprintNBT);
                context.m_43722_().m_41751_(nbt);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_ && ((Boolean)Config.JSON_BLUEPRINT.get()).booleanValue()) {
            BlueprintGUI.open(playerIn.m_21120_(handIn));
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private static List<ItemStack> getRequiredItemStacks(CompoundTag blueprintNBT) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (blueprintNBT.m_128441_("cells")) {
            CompoundTag cellsNBT = blueprintNBT.m_128469_("cells");
            for (String key : cellsNBT.m_128431_()) {
                try {
                    CompoundTag cellDataNBT;
                    Class<?> iPanelCellClass = Class.forName(cellsNBT.m_128469_(key).m_128461_("class"));
                    if (!IPanelCell.class.isAssignableFrom(iPanelCellClass)) continue;
                    Item item = PanelBlock.getPanelCellItemFromClass(iPanelCellClass);
                    ItemStack itemStack = item.m_7968_();
                    if ((iPanelCellClass == TinyBlock.class || iPanelCellClass == TransparentBlock.class) && (cellDataNBT = cellsNBT.m_128469_(key).m_128469_("data")).m_128441_("made_from_namespace")) {
                        CompoundTag madeFromTag = new CompoundTag();
                        madeFromTag.m_128359_("namespace", cellDataNBT.m_128461_("made_from_namespace"));
                        madeFromTag.m_128359_("path", cellDataNBT.m_128461_("made_from_path"));
                        CompoundTag itemTag = new CompoundTag();
                        itemTag.m_128365_("made_from", (Tag)madeFromTag);
                        itemStack.m_41751_(itemTag);
                    }
                    boolean addNeeded = true;
                    for (ItemStack stack : itemStacks) {
                        if (!Blueprint.stacksAreMatchingItem(stack, itemStack)) continue;
                        stack.m_41764_(stack.m_41613_() + 1);
                        addNeeded = false;
                        break;
                    }
                    if (!addNeeded) continue;
                    itemStacks.add(itemStack);
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
        }
        return itemStacks;
    }

    private static boolean playerHasSufficientComponents(List<ItemStack> itemStacks, Player player) {
        for (ItemStack itemStack : itemStacks) {
            int count = 0;
            for (ItemStack invStack : player.m_150109_().f_35974_) {
                if (!Blueprint.stacksAreMatchingItem(invStack, itemStack)) continue;
                count += invStack.m_41613_();
            }
            if (count >= itemStack.m_41613_()) continue;
            return false;
        }
        return true;
    }

    private static boolean stacksAreMatchingItem(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() == stack2.m_41720_() && (!stack1.m_41782_() && !stack2.m_41782_() || stack1.m_41782_() && stack1.m_41783_().equals((Object)stack2.m_41783_()));
    }

    @Nullable
    public static CompoundTag cleanUpBlueprintNBT(CompoundTag nbt) {
        CompoundTag blueprintNBT;
        if (nbt.m_128441_("blueprint") && (blueprintNBT = nbt.m_128469_("blueprint")).m_128441_("cells")) {
            CompoundTag newCellsNBT = new CompoundTag();
            CompoundTag cellsNBT = blueprintNBT.m_128469_("cells");
            for (String key : cellsNBT.m_128431_()) {
                try {
                    if (!IPanelCell.class.isAssignableFrom(Class.forName(cellsNBT.m_128469_(key).m_128461_("class")))) continue;
                    newCellsNBT.m_128365_(key, (Tag)cellsNBT.m_128469_(key));
                }
                catch (ClassNotFoundException e) {
                    TinyRedstone.LOGGER.error("Class not found exception while attempting to read components from blueprint NBT: " + e.getLocalizedMessage());
                }
            }
            CompoundTag newNBT = new CompoundTag();
            CompoundTag newBlueprintNBT = new CompoundTag();
            newNBT.m_128405_("CustomModelData", 1);
            newBlueprintNBT.m_128365_("cells", (Tag)newCellsNBT);
            newNBT.m_128365_("blueprint", (Tag)newBlueprintNBT);
            if (nbt.m_128441_("display")) {
                newNBT.m_128365_("display", (Tag)nbt.m_128469_("display"));
            }
            return newNBT;
        }
        return null;
    }
}

