/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PanelCellSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final CompoundTag nbt;

    public PanelCellSync(BlockPos pos, int cellIndex, CompoundTag nbt) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.nbt = nbt;
    }

    public PanelCellSync(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.cellIndex = buffer.readInt();
        this.nbt = buffer.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.cellIndex);
        buf.m_130079_(this.nbt);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PanelCellPos cellPos;
            IPanelCell cell;
            BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (te instanceof PanelTile && (cell = (cellPos = PanelCellPos.fromIndex((PanelTile)te, this.cellIndex)).getIPanelCell()) != null) {
                cell.readNBT(this.nbt);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

