/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlaySound {
    private final BlockPos pos;
    private final String namespace;
    private final String path;
    private final float volume;
    private final float pitch;

    public PlaySound(BlockPos pos, String namespace, String path, float volume, float pitch) {
        this.pos = pos;
        this.namespace = namespace;
        this.path = path;
        this.volume = volume;
        this.pitch = pitch;
    }

    public PlaySound(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.namespace = buffer.m_130277_();
        this.path = buffer.m_130277_();
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.namespace);
        buf.m_130070_(this.path);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity te = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (te instanceof PanelTile) {
                te.m_58904_().m_7785_((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), new SoundEvent(new ResourceLocation(this.namespace, this.path)), SoundSource.BLOCKS, this.volume, this.pitch, false);
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

