/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.network;

import com.dannyandson.tinyredstone.blocks.ChopperBlockEntity;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.codec.TinyBlockData;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ValidTinyBlockCacheSync {
    ResourceLocation itemRegistryName;
    BlockPos chopperPos;

    public ValidTinyBlockCacheSync(@Nullable BlockPos chopperPos, ResourceLocation itemRegistryName) {
        this.itemRegistryName = itemRegistryName;
        this.chopperPos = chopperPos;
    }

    public ValidTinyBlockCacheSync(FriendlyByteBuf buffer) {
        this.itemRegistryName = buffer.m_130281_();
        try {
            this.chopperPos = buffer.m_130135_();
        }
        catch (IndexOutOfBoundsException e) {
            this.chopperPos = null;
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.itemRegistryName);
        if (this.chopperPos != null) {
            buf.m_130064_(this.chopperPos);
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        return ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT ? this.clientHandle(ctx) : this.serverHandle(ctx);
    }

    public boolean clientHandle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ResourceLocation texture1 = new ResourceLocation(this.itemRegistryName.m_135827_(), "block/" + this.itemRegistryName.m_135815_());
            ResourceLocation texture2 = new ResourceLocation(this.itemRegistryName.m_135827_(), "block/" + this.itemRegistryName.m_135815_() + "_side");
            TextureAtlasSprite sprite1 = RenderHelper.getSprite(texture1);
            TextureAtlasSprite sprite2 = RenderHelper.getSprite(texture2);
            if (sprite1 != RenderHelper.getSprite(TextureManager.f_118466_) || sprite2 != RenderHelper.getSprite(TextureManager.f_118466_)) {
                ModNetworkHandler.sendToServer(new ValidTinyBlockCacheSync(this.chopperPos, this.itemRegistryName));
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }

    public boolean serverHandle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity patt3082$temp;
            if (!TinyBlockData.validBlockTextureCache.contains(this.itemRegistryName.toString())) {
                TinyBlockData.validBlockTextureCache.add(this.itemRegistryName.toString());
            }
            if (this.chopperPos != null && (patt3082$temp = ((NetworkEvent.Context)ctx.get()).getSender().m_183503_().m_7702_(this.chopperPos)) instanceof ChopperBlockEntity) {
                ChopperBlockEntity chopperBlockEntity = (ChopperBlockEntity)patt3082$temp;
                chopperBlockEntity.m_6596_();
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

