/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer;

import java.io.File;
import mods.waterstrainer.Config;
import mods.waterstrainer.event.EventPlayerLoggedIn;
import mods.waterstrainer.event.EventServerStarting;
import mods.waterstrainer.gui.GuiStrainer;
import mods.waterstrainer.gui.GuiWormBin;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.network.PacketHandler;
import mods.waterstrainer.registry.BlockRegistry;
import mods.waterstrainer.registry.FileRegistry;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="waterstrainer")
public class WaterStrainer {
    public static final String MODID = "waterstrainer";
    public static final String MODNAME = "Water Strainer";
    public static final String MODNAME_NOSPACE = "WaterStrainer";
    public static final String VERSION = "1.18-12.1.0";
    public static BlockEntityType<TileEntityStrainer> tile_strainer_base;
    public static BlockEntityType<TileEntityWormBin> tile_worm_bin;
    public static MenuType<ContainerStrainer> container_strainer_base;
    public static MenuType<ContainerWormBin> container_worm_bin;
    public static final CreativeModeTab tabWaterStrainer;
    public static final Logger LOGGER;

    public WaterStrainer() {
        new File("config/waterstrainer").mkdirs();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        PacketHandler.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventServerStarting());
        MinecraftForge.EVENT_BUS.register((Object)new EventPlayerLoggedIn());
    }

    private void commonSetup(FMLCommonSetupEvent e) {
        FileRegistry.LOOTTABLE.init();
    }

    private void clientSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(container_strainer_base, GuiStrainer::new);
        MenuScreens.m_96206_(container_worm_bin, GuiWormBin::new);
        ItemBlockRenderTypes.setRenderLayer((Block)BlockRegistry.strainer_base, (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)BlockRegistry.worm_bin, (RenderType)RenderType.m_110463_());
    }

    static {
        tabWaterStrainer = new CreativeModeTab("waterstrainer.main"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ItemRegistry.strainer_survivalist);
            }
        };
        LOGGER = LogManager.getLogger();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
            tile_strainer_base = (BlockEntityType)BlockEntityType.Builder.m_155273_(TileEntityStrainer::new, (Block[])new Block[]{BlockRegistry.strainer_base}).m_58966_(null).setRegistryName("strainer");
            event.getRegistry().register((IForgeRegistryEntry)tile_strainer_base);
            tile_worm_bin = (BlockEntityType)BlockEntityType.Builder.m_155273_(TileEntityWormBin::new, (Block[])new Block[]{BlockRegistry.worm_bin}).m_58966_(null).setRegistryName("worm_bin");
            event.getRegistry().register((IForgeRegistryEntry)tile_worm_bin);
        }

        @SubscribeEvent
        public static void registerContainer(RegistryEvent.Register<MenuType<?>> event) {
            container_strainer_base = (MenuType)IForgeMenuType.create(ContainerStrainer::new).setRegistryName("container_strainer");
            event.getRegistry().register((IForgeRegistryEntry)container_strainer_base);
            container_worm_bin = (MenuType)IForgeMenuType.create(ContainerWormBin::new).setRegistryName("container_worm_bin");
            event.getRegistry().register((IForgeRegistryEntry)container_worm_bin);
        }
    }
}

