/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.integration.jei.gardentrowel;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mods.waterstrainer.integration.jei.WaterStrainerPlugin;
import mods.waterstrainer.integration.jei.gardentrowel.GardenTrowelRecipe;
import mods.waterstrainer.registry.ItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GardenTrowelCategory
implements IRecipeCategory<GardenTrowelRecipe> {
    private final IDrawable BACKGROUND;
    private final IDrawable ICON;
    private final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("waterstrainer", "textures/gui/jei_garden_trowel.png");

    public GardenTrowelCategory(IGuiHelper guiHelper) {
        this.BACKGROUND = guiHelper.createDrawable(this.BACKGROUND_LOCATION, 0, 0, 170, 56);
        this.ICON = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ItemRegistry.garden_trowel));
    }

    public ResourceLocation getUid() {
        return WaterStrainerPlugin.UID_CAT_GARDEN_TROWEL;
    }

    public Class<? extends GardenTrowelRecipe> getRecipeClass() {
        return GardenTrowelRecipe.class;
    }

    public Component getTitle() {
        return new TextComponent("Worm Drops");
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public void draw(GardenTrowelRecipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        ItemStack input = recipe.getInput().get(1).get(0);
        int chance = Block.m_49814_((Item)input.m_41720_()) == Blocks.f_50093_ ? 50 : 25;
        String chanceStr = chance + "% Chance";
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, chanceStr, (float)(87 - minecraft.f_91062_.m_92895_(chanceStr) / 2), 5.0f, -8355712);
    }

    public void setIngredients(GardenTrowelRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.getInput());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getOutput());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GardenTrowelRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 36, 19);
        guiItemStacks.init(1, true, 56, 19);
        guiItemStacks.init(2, false, 116, 19);
        guiItemStacks.set(ingredients);
    }
}

