/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.TankState;
import edivad.dimstorage.network.packet.SyncLiquidTank;
import edivad.dimstorage.setup.Registration;
import edivad.dimstorage.storage.DimTankStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;

public class BlockEntityDimTank
extends BlockEntityFrequencyOwner {
    public DimTankState liquidState = new DimTankState();
    public boolean autoEject = false;
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.empty();

    public BlockEntityDimTank(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.DIMTANK_TILE.get(), pos, state);
    }

    @Override
    public void onServerTick(Level level, BlockPos pos, BlockState state) {
        if (this.autoEject) {
            this.ejectLiquid();
        }
        this.liquidState.update(false);
    }

    @Override
    public void onClientTick(Level level, BlockPos pos, BlockState state) {
        this.liquidState.update(true);
    }

    private void ejectLiquid() {
        for (Direction side : Direction.values()) {
            BlockEntity blockentity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(side));
            if (blockentity == null || !this.checkSameFrequency(blockentity)) continue;
            blockentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.m_122424_()).ifPresent(h -> {
                int qty;
                FluidStack liquid = this.getStorage().drain(100, IFluidHandler.FluidAction.SIMULATE);
                if (liquid.getAmount() > 0 && (qty = h.fill(liquid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    this.getStorage().drain(qty, IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
    }

    private boolean checkSameFrequency(BlockEntity blockentity) {
        if (blockentity instanceof BlockEntityDimTank) {
            BlockEntityDimTank otherTank = (BlockEntityDimTank)blockentity;
            return !this.getFrequency().equals(otherTank.getFrequency());
        }
        return true;
    }

    @Override
    public void setFrequency(Frequency frequency) {
        super.setFrequency(frequency);
        if (!this.f_58857_.f_46443_) {
            this.liquidState.setFrequency(frequency);
        }
        this.fluidHandler.invalidate();
        this.fluidHandler = LazyOptional.of(this::getStorage);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.fluidHandler.invalidate();
        this.fluidHandler = LazyOptional.of(this::getStorage);
    }

    public void m_7651_() {
        super.m_7651_();
        this.fluidHandler.invalidate();
    }

    @Override
    public DimTankStorage getStorage() {
        return (DimTankStorage)DimStorageManager.instance(this.f_58857_.f_46443_).getStorage(this.getFrequency(), "fluid");
    }

    public int getComparatorInput() {
        int amount = this.getStorage().getFluidInTank(0).getAmount();
        return amount / 1000;
    }

    public void swapAutoEject() {
        this.autoEject = !this.autoEject;
        this.m_6596_();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("autoEject", this.autoEject);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.liquidState.setFrequency(this.getFrequency());
        this.autoEject = tag.m_128471_("autoEject");
    }

    @Override
    public InteractionResult activate(Player player, Level level, BlockPos pos, InteractionHand hand) {
        if (!this.canAccess(player)) {
            player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Access Denied!"), false);
            return super.activate(player, level, pos, hand);
        }
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.getStorage());
        if (!result) {
            return super.activate(player, level, pos, hand);
        }
        level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.locked && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag root = new CompoundTag();
        root.m_128365_("Frequency", (Tag)this.getFrequency().serializeNBT());
        root.m_128379_("locked", this.locked);
        root.m_128379_("autoEject", this.autoEject);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        this.setFrequency(new Frequency(tag.m_128469_("Frequency")));
        this.locked = tag.m_128471_("locked");
        this.autoEject = tag.m_128471_("autoEject");
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128379_("autoEject", this.autoEject);
        return tag;
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        this.setFrequency(new Frequency(tag.m_128469_("Frequency")));
        this.locked = tag.m_128471_("locked");
        this.autoEject = tag.m_128471_("autoEject");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ContainerDimTank(id, inventory, this, false);
    }

    public class DimTankState
    extends TankState {
        @Override
        public void sendSyncPacket() {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncLiquidTank(BlockEntityDimTank.this.m_58899_(), this.serverLiquid));
        }

        @Override
        public void onLiquidChanged() {
            BlockEntityDimTank.this.f_58857_.m_7260_(BlockEntityDimTank.this.m_58899_(), BlockEntityDimTank.this.m_58900_(), BlockEntityDimTank.this.m_58900_(), 3);
            BlockEntityDimTank.this.f_58857_.m_7726_().m_7827_().m_142202_(BlockEntityDimTank.this.m_58899_());
        }
    }
}

