/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.blockentities;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public abstract class BlockEntityFrequencyOwner
extends BlockEntity
implements MenuProvider {
    public boolean locked = false;
    private Frequency frequency = new Frequency();
    private int changeCount;

    public BlockEntityFrequencyOwner(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void setFrequency(Frequency frequency) {
        this.frequency.set(frequency);
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }

    public Frequency getFrequency() {
        return this.frequency.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void swapOwner() {
        if (this.frequency.hasOwner()) {
            this.setFrequency(this.getFrequency().setPublic());
        } else {
            this.setFrequency(this.getFrequency().setOwner((Player)Minecraft.m_91087_().f_91074_));
        }
    }

    public void swapLocked() {
        this.locked = !this.locked;
        this.m_6596_();
    }

    public boolean canAccess(Player player) {
        return this.frequency.canAccess(player);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        if (blockentity.getStorage().getChangeCount() > blockentity.changeCount) {
            level.m_46717_(blockentity.f_58858_, blockentity.m_58900_().m_60734_());
            blockentity.changeCount = blockentity.getStorage().getChangeCount();
        }
        blockentity.onServerTick(level, pos, state);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntityFrequencyOwner blockentity) {
        blockentity.onClientTick(level, pos, state);
    }

    public abstract AbstractDimStorage getStorage();

    public abstract void onServerTick(Level var1, BlockPos var2, BlockState var3);

    public abstract void onClientTick(Level var1, BlockPos var2, BlockState var3);

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.frequency.set(new Frequency(tag.m_128469_("Frequency")));
        this.locked = tag.m_128471_("locked");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Frequency", (Tag)this.frequency.serializeNBT());
        tag.m_128379_("locked", this.locked);
    }

    public InteractionResult activate(Player player, Level level, BlockPos pos, InteractionHand hand) {
        if (this.canAccess(player)) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.m_130064_(this.m_58899_()).writeBoolean(false));
        } else {
            player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Access Denied!"), false);
        }
        return InteractionResult.SUCCESS;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("Frequency", (Tag)this.frequency.serializeNBT());
        tag.m_128379_("locked", this.locked);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setFrequency(new Frequency(tag.m_128469_("Frequency")));
        this.locked = tag.m_128471_("locked");
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }
}

