/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.tools.utils.FluidUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class DimTankRenderer
implements BlockEntityRenderer<BlockEntityDimTank> {
    private static final float TANK_THICKNESS = 0.1f;

    public DimTankRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDimTank blockentity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (blockentity.m_58901_() || blockentity.liquidState.clientLiquid == null) {
            return;
        }
        poseStack.m_85836_();
        this.renderFluid(blockentity, poseStack, bufferIn);
        poseStack.m_85849_();
    }

    private void renderFluid(BlockEntityDimTank blockentity, PoseStack poseStack, MultiBufferSource bufferIn) {
        FluidStack fluid = blockentity.liquidState.clientLiquid;
        float scale = 0.84999996f * (float)fluid.getAmount() / 16000.0f;
        if (scale > 0.0f) {
            Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
            TextureAtlasSprite sprite = FluidUtils.getFluidTexture(fluid);
            if (sprite == null) {
                return;
            }
            VertexConsumer renderer = bufferIn.m_6299_(RenderType.m_110497_((ResourceLocation)sprite.m_118414_().m_118330_()));
            float u1 = sprite.m_118409_();
            float v1 = sprite.m_118411_();
            float u2 = sprite.m_118410_();
            float v2 = sprite.m_118412_();
            float margin = 0.9f;
            float offset = 0.1f;
            int color = FluidUtils.getLiquidColorWithBiome(fluid, blockentity);
            float r = FluidUtils.getRed(color);
            float g = FluidUtils.getGreen(color);
            float b = FluidUtils.getBlue(color);
            float a = FluidUtils.getAlpha(color);
            int light = 0xF000F0;
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, margin - 0.1f, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v1).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, 0.1f + offset).m_85950_(r, g, b, a).m_7421_(u1, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v2).m_85969_(light).m_5752_();
            renderer.m_85982_(matrix4f, 0.1f + offset, scale + 0.1f, margin - 0.1f).m_85950_(r, g, b, a).m_7421_(u2, v1).m_85969_(light).m_5752_();
        }
    }
}

