/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.storage;

import edivad.dimstorage.api.AbstractDimStorage;
import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.manager.DimStorageManager;
import edivad.dimstorage.network.PacketHandler;
import edivad.dimstorage.network.packet.OpenChest;
import edivad.dimstorage.tools.utils.InventoryUtils;
import java.util.Arrays;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class DimChestStorage
extends AbstractDimStorage
implements Container {
    private ItemStack[] items;
    private int open;

    public DimChestStorage(DimStorageManager manager, Frequency freq) {
        super(manager, freq);
        this.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearStorage() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.empty();
            this.setDirty();
        }
    }

    @Override
    public void loadFromTag(CompoundTag tag) {
        this.empty();
        InventoryUtils.readItemStacksFromTag(this.items, tag.m_128437_("Items", 10));
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public CompoundTag saveToTag() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("Items", (Tag)InventoryUtils.writeItemStacksToTag(this.items));
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_8020_(int slot) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_8016_(int index) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.removeStackFromSlot(this, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6836_(int slot, ItemStack stack) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items[slot] = stack;
            this.m_6596_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                ++this.open;
                if (this.open >= 1) {
                    PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new OpenChest(this.freq, true));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeInventory() {
        if (this.manager.isServer()) {
            DimChestStorage dimChestStorage = this;
            synchronized (dimChestStorage) {
                --this.open;
                if (this.open <= 0) {
                    PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new OpenChest(this.freq, false));
                }
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int m_6643_() {
        return 54;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack m_7407_(int slot, int size) {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            return InventoryUtils.decrStackSize(this, slot, size);
        }
    }

    public int m_6893_() {
        return 64;
    }

    public void m_6596_() {
        this.setDirty();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void empty() {
        DimChestStorage dimChestStorage = this;
        synchronized (dimChestStorage) {
            this.items = new ItemStack[this.m_6643_()];
            Arrays.fill(this.items, ItemStack.f_41583_);
        }
    }

    public void setClientOpen(int i) {
        if (!this.manager.isServer()) {
            this.open = i;
        }
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return true;
    }

    public void m_6211_() {
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }
}

