/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.tools.utils;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.InvWrapper;

public class InventoryUtils {
    public static void readItemStacksFromTag(ItemStack[] items, ListTag tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            short b = tag.m_128448_("Slot");
            items[b] = ItemStack.m_41712_((CompoundTag)tag);
            Tag quant = tag.m_128423_("Quantity");
            if (!(quant instanceof NumericTag)) continue;
            items[b].m_41764_(((NumericTag)quant).m_7047_());
        }
    }

    public static ListTag writeItemStacksToTag(ItemStack[] items) {
        return InventoryUtils.writeItemStacksToTag(items, 64);
    }

    public static ListTag writeItemStacksToTag(ItemStack[] items, int maxQuantity) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < items.length; ++i) {
            CompoundTag tag = new CompoundTag();
            tag.m_128376_("Slot", (short)i);
            items[i].m_41739_(tag);
            if (maxQuantity > Short.MAX_VALUE) {
                tag.m_128405_("Quantity", items[i].m_41613_());
            } else if (maxQuantity > 127) {
                tag.m_128376_("Quantity", (short)items[i].m_41613_());
            }
            tagList.add((Object)tag);
        }
        return tagList;
    }

    public static ItemStack removeStackFromSlot(Container inv, int slot) {
        ItemStack stack = inv.m_8020_(slot);
        inv.m_6836_(slot, ItemStack.f_41583_);
        return stack;
    }

    @Nonnull
    public static ItemStack decrStackSize(Container inv, int slot, int size) {
        ItemStack item = inv.m_8020_(slot);
        if (!item.m_41619_()) {
            if (item.m_41613_() <= size) {
                inv.m_6836_(slot, ItemStack.f_41583_);
                inv.m_6596_();
                return item;
            }
            ItemStack itemstack1 = item.m_41620_(size);
            if (item.m_41613_() == 0) {
                inv.m_6836_(slot, ItemStack.f_41583_);
            } else {
                inv.m_6836_(slot, item);
            }
            inv.m_6596_();
            return itemstack1;
        }
        return ItemStack.f_41583_;
    }

    public static boolean mergeItemStack(ItemStack stack, int startIndex, int endIndex, InvWrapper wrapper) {
        int i;
        boolean flag = false;
        if (stack.m_41753_()) {
            for (i = startIndex; !stack.m_41619_() && i < endIndex; ++i) {
                int maxSize;
                ItemStack itemstack = wrapper.getStackInSlot(i);
                if (itemstack.m_41619_() || !stack.m_41656_(itemstack)) continue;
                int j = itemstack.m_41613_() + stack.m_41613_();
                if (j <= (maxSize = stack.m_41741_())) {
                    stack.m_41764_(0);
                    itemstack.m_41764_(j);
                    flag = true;
                    continue;
                }
                if (itemstack.m_41613_() >= maxSize) continue;
                stack.m_41774_(maxSize - itemstack.m_41613_());
                itemstack.m_41764_(maxSize);
                flag = true;
            }
        }
        if (!stack.m_41619_()) {
            for (i = startIndex; i < endIndex && !flag; ++i) {
                ItemStack itemstack1 = wrapper.getStackInSlot(i);
                if (!itemstack1.m_41619_() || !wrapper.isItemValid(i, stack)) continue;
                if (stack.m_41613_() > 64) {
                    wrapper.setStackInSlot(i, stack.m_41620_(64));
                } else {
                    wrapper.setStackInSlot(i, stack.m_41620_(stack.m_41613_()));
                }
                flag = true;
            }
        }
        return flag;
    }
}

