/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(Minecraft mc, Player player) {
        if (Level.f_46429_.equals((Object)player.f_19853_.m_46472_())) {
            return true;
        }
        int posX = Mth.m_14107_((double)player.m_20185_());
        int posY = Mth.m_14107_((double)player.m_142469_().f_82289_);
        int posZ = Mth.m_14107_((double)player.m_20189_());
        boolean offset = true;
        boolean isUnderground = false;
        if (posY < player.m_183503_().m_141937_()) {
            return true;
        }
        int y = posY;
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(new ChunkPos(x >> 4, z >> 4));
                if (chunkMD == null) continue;
                if (chunkMD.ceiling(x & 0xF, z & 0xF) <= y) {
                    isUnderground = false;
                    break block0;
                }
                isUnderground = true;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
        dto.update((LivingEntity)player, false);
        dto.biome = this.getPlayerBiome((Player)player);
        dto.underground = PlayerData.playerIsUnderground(mc, (Player)player);
        return dto;
    }

    private String getPlayerBiome(Player player) {
        if (player != null) {
            try {
                Biome biome = Minecraft.m_91087_().f_91073_.m_46857_(player.m_142538_());
                if (biome != null) {
                    return BiomeHelper.getTranslatedBiomeName(biome);
                }
            }
            catch (Exception e) {
                JMLogger.logOnce("Couldn't get player biome: " + e.getMessage(), e);
            }
        }
        return "?";
    }

    public long getTTL() {
        return JourneymapClient.getInstance().getCoreProperties().cachePlayerData.get().intValue();
    }
}

