/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.client.Constants;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.log.ChatLog;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.dialog.OptionsManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.catagory.Category;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class KeyEventHandler
implements EventHandlerManager.EventHandler {
    private static KeyEventHandler instance;
    public KeyMapping kbMapZoomin;
    public KeyMapping kbMapZoomout;
    public KeyMapping kbMapToggleType;
    public KeyMapping kbCreateWaypoint;
    public KeyMapping kbToggleAllWaypoints;
    public KeyMapping kbFullscreenCreateWaypoint;
    public KeyMapping kbFullscreenChatPosition;
    public KeyMapping kbFullscreenToggle;
    public KeyMapping kbWaypointManager;
    public KeyMapping kbMinimapToggle;
    public KeyMapping kbMinimapPreset;
    public KeyMapping kbFullmapOptionsManager;
    public KeyMapping kbFullmapPanNorth;
    public KeyMapping kbFullmapPanSouth;
    public KeyMapping kbFullmapPanEast;
    public KeyMapping kbFullmapPanWest;
    public KeyMapping kbFullmapButtonHide;
    private Comparator<KeyBindingAction> kbaComparator = Comparator.comparingInt(KeyBindingAction::order);
    private final ListMultimap<Integer, KeyBindingAction> minimapPreviewActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private final ListMultimap<Integer, KeyBindingAction> inGameActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private final ListMultimap<Integer, KeyBindingAction> inGuiActions = MultimapBuilder.hashKeys().arrayListValues(2).build();
    private Minecraft mc = Minecraft.m_91087_();
    private boolean sortActionsNeeded = true;
    private Logger logger = Journeymap.getLogger();

    private KeyEventHandler() {
        this.kbMapZoomin = this.register("key.journeymap.zoom_in", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 61);
        this.kbMapZoomout = this.register("key.journeymap.zoom_out", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 45);
        this.kbMapToggleType = this.register("key.journeymap.minimap_type", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 91);
        this.kbMinimapPreset = this.register("key.journeymap.minimap_preset", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 92);
        this.kbCreateWaypoint = this.register("key.journeymap.create_waypoint", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 66);
        this.kbToggleAllWaypoints = this.register("key.journeymap.toggle_waypoints", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 90);
        this.kbFullscreenCreateWaypoint = this.register("key.journeymap.fullscreen_create_waypoint", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 66);
        this.kbFullscreenChatPosition = this.register("key.journeymap.fullscreen_chat_position", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 67);
        this.kbFullscreenToggle = this.register("key.journeymap.map_toggle_alt", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 74);
        this.kbWaypointManager = this.register("key.journeymap.fullscreen_waypoints", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.CONTROL, 66);
        this.kbMinimapToggle = this.register("key.journeymap.minimap_toggle_alt", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.CONTROL, 74);
        this.kbFullmapOptionsManager = this.register("key.journeymap.fullscreen_options", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 79);
        this.kbFullmapPanNorth = this.register("key.journeymap.fullscreen.north", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 265);
        this.kbFullmapPanSouth = this.register("key.journeymap.fullscreen.south", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 264);
        this.kbFullmapPanEast = this.register("key.journeymap.fullscreen.east", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 262);
        this.kbFullmapPanWest = this.register("key.journeymap.fullscreen.west", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 263);
        this.kbFullmapButtonHide = this.register("key.journeymap.fullscreen.disable_buttons", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 72);
    }

    public static void init() {
        KeyEventHandler.getInstance();
    }

    public static KeyEventHandler getInstance() {
        if (instance == null) {
            instance = new KeyEventHandler();
        }
        return instance;
    }

    public KeyEventHandler registerActions() {
        this.setAction(this.minimapPreviewActions, this.kbMapZoomin, () -> MiniMap.state().zoomIn());
        this.setAction(this.inGuiActions, this.kbMapZoomin, () -> this.getFullscreen().zoomIn());
        this.setAction(this.minimapPreviewActions, this.kbMapZoomout, () -> MiniMap.state().zoomOut());
        this.setAction(this.inGuiActions, this.kbMapZoomout, () -> this.getFullscreen().zoomOut());
        this.setAction(this.minimapPreviewActions, this.kbMapToggleType, () -> MiniMap.state().toggleMapType());
        this.setAction(this.inGuiActions, this.kbMapToggleType, () -> this.getFullscreen().toggleMapType());
        this.setAction(this.minimapPreviewActions, this.kbMinimapPreset, UIManager.INSTANCE::switchMiniMapPreset);
        this.inGameActions.putAll(this.minimapPreviewActions);
        this.setAction(this.inGameActions, this.kbCreateWaypoint, () -> {
            this.mc.f_91068_.m_90926_(false);
            UIManager.INSTANCE.openWaypointEditor(Waypoint.of((Entity)this.mc.f_91074_), true, null);
        });
        this.setAction(this.inGameActions, this.kbToggleAllWaypoints, WaypointManager::toggleAllWaypoints);
        this.setAction(this.inGuiActions, this.kbFullscreenCreateWaypoint, () -> this.getFullscreen().createWaypointAtMouse());
        this.setAction(this.inGuiActions, this.kbFullscreenChatPosition, () -> this.getFullscreen().chatPositionAtMouse());
        this.setAction(this.inGameActions, this.kbFullscreenToggle, UIManager.INSTANCE::openFullscreenMap);
        this.setAction(this.inGuiActions, this.kbFullscreenToggle, UIManager.INSTANCE::closeAll);
        this.setAction(this.inGameActions, this.kbWaypointManager, () -> UIManager.INSTANCE.openWaypointManager(null, null));
        this.setAction(this.inGuiActions, this.kbWaypointManager, () -> {
            if (this.inFullscreenWithoutChat()) {
                UIManager.INSTANCE.openWaypointManager(null, this.getFullscreen());
            }
        });
        this.setAction(this.inGameActions, this.kbMinimapToggle, UIManager.INSTANCE::toggleMinimap);
        this.setAction(this.inGuiActions, this.kbFullmapOptionsManager, () -> UIManager.INSTANCE.openOptionsManager(this.getFullscreen(), new Category[0]));
        this.setAction(this.inGuiActions, this.kbFullmapPanNorth, () -> this.getFullscreen().moveCanvas(0, -16));
        this.setAction(this.inGuiActions, this.kbFullmapPanSouth, () -> this.getFullscreen().moveCanvas(0, 16));
        this.setAction(this.inGuiActions, this.kbFullmapPanEast, () -> this.getFullscreen().moveCanvas(16, 0));
        this.setAction(this.inGuiActions, this.kbFullmapPanWest, () -> this.getFullscreen().moveCanvas(-16, 0));
        this.setAction(this.inGuiActions, this.kbFullmapButtonHide, () -> this.getFullscreen().hideButtons());
        return this;
    }

    private void setAction(ListMultimap<Integer, KeyBindingAction> multimap, KeyMapping keyBinding, Runnable action) {
        multimap.put((Object)keyBinding.getKey().m_84873_(), (Object)new KeyBindingAction(keyBinding, action));
    }

    private KeyMapping register(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        String category = keyConflictContext == KeyConflictContext.GUI ? Constants.getString("jm.common.hotkeys_keybinding_fullscreen_category") : Constants.getString("jm.common.hotkeys_keybinding_category");
        UpdateAwareKeyBinding kb = new UpdateAwareKeyBinding(description, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM, keyCode, category);
        try {
            ClientRegistry.registerKeyBinding((KeyMapping)kb);
        }
        catch (Throwable t) {
            ChatLog.announceError("Unexpected error when registering keybinding : " + kb);
        }
        return kb;
    }

    @SubscribeEvent
    public void onGameKeyboardEvent(InputEvent.KeyInputEvent event) {
        int key = event.getKey();
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key) && !this.isInChat() && this.emptyScreen()) {
            this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGameActions, key, true, (Event)event);
        }
    }

    @SubscribeEvent
    public void onGuiKeyboardEvent(ScreenEvent.KeyboardKeyPressedEvent.Post event) {
        int key = event.getKeyCode();
        if (event.getScreen() == null) {
            event.setCanceled(true);
            return;
        }
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)key)) {
            if (this.inFullscreenWithoutChat()) {
                if (this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, (Event)event)) {
                    event.setCanceled(true);
                }
            } else if (this.inMinimapPreview() && this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, (Event)event)) {
                ((OptionsManager)this.mc.f_91080_).refreshMinimapOptions();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseEvent(ScreenEvent.MouseClickedEvent.Post event) {
        int key = event.getButton();
        if (this.inFullscreenWithoutChat()) {
            if (this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.inGuiActions, key, true, (Event)event)) {
                event.setCanceled(true);
            }
        } else if (this.inMinimapPreview() && this.onInputEvent((Multimap<Integer, KeyBindingAction>)this.minimapPreviewActions, key, false, (Event)event)) {
            ((OptionsManager)this.mc.f_91080_).refreshMinimapOptions();
        }
    }

    public List<KeyMapping> getInGuiKeybindings() {
        List<KeyMapping> list = this.inGuiActions.values().stream().map(KeyBindingAction::getKeyBinding).collect(Collectors.toList());
        list.sort(Comparator.comparing(kb -> Constants.getString(kb.m_90860_())));
        return list;
    }

    private boolean onInputEvent(Multimap<Integer, KeyBindingAction> multimap, int key, boolean useContext, Event event) {
        try {
            if (this.sortActionsNeeded) {
                this.sortActions();
            }
            for (KeyBindingAction kba : multimap.get((Object)key)) {
                if (!kba.isActive(key, useContext) || Minecraft.m_91087_().f_91073_ == null || !this.canUseKey()) continue;
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
                this.logger.debug("Firing " + kba);
                kba.getAction().run();
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error("Error checking keybinding", (Object)LogFormatter.toPartialString(e));
        }
        return false;
    }

    private void sortActions() {
        this.sortActions(this.minimapPreviewActions);
        this.sortActions(this.inGameActions);
        this.sortActions(this.inGuiActions);
        this.sortActionsNeeded = false;
    }

    private void sortActions(ListMultimap<Integer, KeyBindingAction> multimap) {
        ArrayList copy = new ArrayList(multimap.values());
        multimap.clear();
        for (KeyBindingAction kba : copy) {
            multimap.put((Object)kba.getKeyBinding().getKey().m_84873_(), (Object)kba);
        }
        for (Integer key : multimap.keySet()) {
            multimap.get((Object)key).sort(this.kbaComparator);
            Journeymap.getLogger().debug((Object)multimap.get((Object)key));
        }
    }

    private Fullscreen getFullscreen() {
        return UIManager.INSTANCE.openFullscreenMap();
    }

    private boolean isInChat() {
        return this.mc.f_91080_ instanceof ChatScreen;
    }

    private boolean canUseKey() {
        return this.mc.f_91080_ instanceof JmUI || this.mc.f_91080_ == null;
    }

    private boolean emptyScreen() {
        return this.mc.f_91080_ == null;
    }

    private boolean inFullscreenWithoutChat() {
        return this.mc.f_91080_ instanceof Fullscreen && !((Fullscreen)this.mc.f_91080_).isChatOpen();
    }

    private boolean inFullscreenWithChatOpen() {
        return this.mc.f_91080_ instanceof Fullscreen && ((Fullscreen)this.mc.f_91080_).isChatOpen();
    }

    private boolean inMinimapPreview() {
        return this.mc.f_91080_ instanceof OptionsManager && ((OptionsManager)this.mc.f_91080_).previewMiniMap();
    }

    static class KeyBindingAction {
        KeyMapping keyBinding;
        Runnable action;

        public KeyBindingAction(KeyMapping keyBinding, Runnable action) {
            this.keyBinding = keyBinding;
            this.action = action;
        }

        boolean isActive(int key, boolean useContext) {
            if (useContext) {
                return this.keyBinding.isActiveAndMatches(InputConstants.Type.KEYSYM.m_84895_(key));
            }
            return this.keyBinding.getKey().m_84873_() == key && this.keyBinding.getKeyModifier().isActive(null);
        }

        Runnable getAction() {
            return this.action;
        }

        KeyMapping getKeyBinding() {
            return this.keyBinding;
        }

        int order() {
            return this.keyBinding.getKeyModifier().ordinal();
        }

        public String toString() {
            return "KeyBindingAction{" + this.keyBinding.m_90863_().getString().toUpperCase() + " = " + Constants.getString(this.keyBinding.m_90860_()) + "}";
        }
    }

    class UpdateAwareKeyBinding
    extends KeyMapping {
        UpdateAwareKeyBinding(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, String category) {
            super(description, keyConflictContext, keyModifier, inputType, keyCode, category);
        }

        public void m_90848_(InputConstants.Key key) {
            super.m_90848_(key);
            KeyEventHandler.this.sortActionsNeeded = true;
        }

        public void setKeyModifierAndCode(KeyModifier keyModifier, InputConstants.Key keyCode) {
            super.setKeyModifierAndCode(keyModifier, keyCode);
            KeyEventHandler.this.sortActionsNeeded = true;
        }
    }
}

