/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.apache.logging.log4j.Logger;

public abstract class JmUI
extends Screen {
    protected final String f_96539_;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected int scaleFactor = 1;
    protected TextureImpl logo = TextureCache.getTexture(TextureCache.Logo);
    protected static Stack<Screen> returnDisplayStack = new Stack();
    protected boolean renderBottomBar = false;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, Screen returnDisplay) {
        super((Component)Constants.getStringTextComponent(title));
        this.f_96539_ = title;
        returnDisplayStack.push(returnDisplay);
    }

    public Minecraft getMinecraft() {
        this.f_96541_ = Minecraft.m_91087_();
        return this.f_96541_;
    }

    public void m_6575_(Minecraft minecraft, int width, int height) {
        super.m_6575_(minecraft, width, height);
        this.scaleFactor = (int)minecraft.m_91268_().m_85449_();
    }

    public boolean m_7043_() {
        return true;
    }

    public Font getFontRenderer() {
        return this.f_96547_;
    }

    public void sizeDisplay(PoseStack mStack, boolean scaled) {
        int glwidth = scaled ? this.f_96543_ : this.f_96541_.m_91268_().m_85443_();
        int glheight = scaled ? this.f_96544_ : this.f_96541_.m_91268_().m_85444_();
        DrawUtil.sizeDisplay(mStack, glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.f_169369_.size(); ++k) {
            Button button;
            net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.f_169369_.get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseEvent) {
        return super.m_6348_(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(PoseStack mStack) {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(mStack, this.f_96541_.m_91268_().m_85443_(), this.f_96541_.m_91268_().m_85444_());
        DrawUtil.drawImage(mStack, this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(mStack, this.f_96543_, this.f_96544_);
    }

    protected void renderBottomBar(PoseStack stack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(stack, 0.0, this.f_96544_ - 30, this.f_96543_, this.f_96544_, 0, 0.6f);
        }
    }

    protected void drawTitle(PoseStack mStack) {
        DrawUtil.drawRectangle(mStack, 0.0, 0.0, this.f_96543_, 35.0, 0, 0.9f);
        DrawUtil.drawLabel(mStack, this.f_96539_, this.f_96543_ / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v1.8-SNAPSHOT";
        DrawUtil.drawLabel(mStack, apiVersion, this.f_96543_ - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void m_7856_() {
        this.f_169369_.clear();
    }

    public void m_7333_(PoseStack mStack) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            this.drawGradientRect(mStack, 0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        } else {
            super.m_7333_(mStack);
        }
    }

    protected abstract void layoutButtons(PoseStack var1);

    public List getButtonList() {
        return this.f_169369_;
    }

    public void m_6305_(PoseStack mStack, int x, int y, float par3) {
        try {
            this.m_7333_(mStack);
            this.renderBottomBar(mStack);
            this.layoutButtons(mStack);
            this.drawTitle(mStack);
            this.drawLogo(mStack);
            List<FormattedCharSequence> tooltip = null;
            for (int k = 0; k < this.f_169369_.size(); ++k) {
                Button button;
                net.minecraft.client.gui.components.Button guibutton = (net.minecraft.client.gui.components.Button)this.f_169369_.get(k);
                guibutton.m_6305_(mStack, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(mStack, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(PoseStack mStack, int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.m_93179_(mStack, p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    public void close() {
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            if (this.f_96541_.f_91073_ != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public boolean m_5534_(char c, int i) {
        return super.m_5534_(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean m_7933_(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.m_7933_(key, value, modifier);
    }

    public void renderTooltip(PoseStack mStack, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> FormattedCharSequence.m_13714_((String)e, (Style)Style.f_131099_)).collect(Collectors.toList());
        this.renderWrappedToolTip(mStack, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public Screen getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(PoseStack mStack, List tooltip, int mouseX, int mouseY, Font fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof FormattedCharSequence) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (FormattedCharSequence line : tooltip) {
                int lineWidth = fontRenderer.m_92724_(line);
                if (fontRenderer.m_92718_()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.f_96543_) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.f_96544_) {
                drawY = this.f_96544_ - boxHeight - 6;
            }
            this.m_93250_(300);
            this.f_96542_.f_115093_ = 300.0f;
            int j1 = -267386864;
            this.drawGradientRect(mStack, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(mStack, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                FormattedCharSequence line = (FormattedCharSequence)tooltip.get(i2);
                if (fontRenderer.m_92718_()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.m_92724_(line) * 1.1);
                    fontRenderer.m_92744_(mStack, line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1);
                } else {
                    fontRenderer.m_92744_(mStack, line, (float)drawX, (float)drawY, -1);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            this.m_93250_(0);
            this.f_96542_.f_115093_ = 0.0f;
            RenderWrapper.enableDepthTest();
        }
    }
}

