/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.event;

import java.util.EnumSet;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import journeymap.client.api.impl.ClientAPI;

public class FullscreenEventReceiver
implements IClientPlugin {
    ClientAPI api;

    @Override
    public void initialize(IClientAPI api) {
        api.subscribe("journeymap", EnumSet.of(ClientEvent.Type.MAPPING_STARTED, ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.REGISTRY));
        this.api = (ClientAPI)api;
    }

    @Override
    public String getModId() {
        return "journeymap";
    }

    @Override
    public void onEvent(ClientEvent clientEvent) {
        if (ClientEvent.Type.MAPPING_STARTED.equals((Object)clientEvent.type)) {
            // empty if block
        }
        if (!ClientEvent.Type.MAPPING_STOPPED.equals((Object)clientEvent.type) && ClientEvent.Type.REGISTRY.equals((Object)clientEvent.type)) {
            RegistryEvent registryEvent = (RegistryEvent)clientEvent;
            switch (registryEvent.getRegistryType()) {
                case INFO_SLOT: {
                    ((RegistryEvent.InfoSlotRegistryEvent)registryEvent).register("Test", "Current Millis", 1000L, () -> "Millis: " + System.currentTimeMillis());
                    ((RegistryEvent.InfoSlotRegistryEvent)registryEvent).register("Test", "Current Ticks", 10L, () -> "");
                }
            }
        }
    }
}

