/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.api.impl.BlockInfo;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.RegionCoord;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.fullscreen.FullscreenEventHandler;
import journeymap.client.ui.fullscreen.layer.Layer;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.theme.Theme;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class BlockInfoLayer
extends Layer {
    private final List<DrawStep> drawStepList = new ArrayList<DrawStep>(1);
    LocationFormat locationFormat = new LocationFormat();
    LocationFormat.LocationFormatKeys locationFormatKeys;
    BlockPos lastCoord = null;
    PlayerInfoStep playerInfoStep;
    BlockInfoStep blockInfoStep = new BlockInfoStep();
    private boolean isSinglePlayer;
    private final Minecraft mc;

    public BlockInfoLayer(Fullscreen fullscreen) {
        super(fullscreen);
        this.playerInfoStep = new PlayerInfoStep();
        this.mc = Minecraft.m_91087_();
        this.isSinglePlayer = this.mc.m_91091_();
    }

    @Override
    public List<DrawStep> onMouseMove(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockPos, float fontScale, boolean isScrolling) {
        Rectangle2D.Double optionsToolbarRect = this.fullscreen.getOptionsToolbarBounds();
        Rectangle2D.Double menuToolbarRect = this.fullscreen.getMenuToolbarBounds();
        if (optionsToolbarRect == null || menuToolbarRect == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.drawStepList.isEmpty()) {
            this.drawStepList.add(this.playerInfoStep);
            this.drawStepList.add(this.blockInfoStep);
        }
        this.playerInfoStep.update(mc.m_91268_().m_85443_() / 2, optionsToolbarRect.getMaxY());
        if (!blockPos.equals((Object)this.lastCoord)) {
            BlockInfo.Builder infoBuilder = BlockInfo.builder();
            this.lastCoord = blockPos;
            ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(blockPos);
            String info = "";
            infoBuilder.withBlockPos(blockPos);
            RegionCoord regionCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(Minecraft.m_91087_()), gridRenderer.getMapType(), blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(regionCoord, gridRenderer.getMapType());
            Block block = null;
            Biome biome = null;
            if (regionData != null) {
                block = regionData.getBlock(blockPos);
                biome = regionData.getBiome(blockPos);
            }
            if (chunkMD != null && chunkMD.hasChunk()) {
                BlockMD blockMD = chunkMD.getBlockMD(blockPos.m_7494_());
                if (blockMD == null || blockMD.isIgnore()) {
                    blockMD = chunkMD.getBlockMD(blockPos.m_7495_());
                    if (block == null && !blockMD.isIgnore()) {
                        block = blockMD.getBlock();
                    }
                }
                infoBuilder.withChunk(chunkMD.getChunk());
                infoBuilder.withBlockState(blockMD.getBlockState());
            }
            if (biome == null && this.isSinglePlayer) {
                biome = JmBlockAccess.INSTANCE.getBiome(blockPos);
            }
            String biomeName = "";
            if (biome != null) {
                biomeName = BiomeHelper.getTranslatedBiomeName(biome);
            }
            infoBuilder.withChunkPos(new ChunkPos(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4));
            infoBuilder.withBiome(biome);
            infoBuilder.withRegionX(regionCoord.regionX);
            infoBuilder.withRegionZ(regionCoord.regionZ);
            info = this.getBlockInfo(blockPos, biomeName, regionCoord);
            if (block != null) {
                infoBuilder.withBlock(block);
                String blockName = BlockMD.getBlockName(block);
                info = String.format("%s \u25a0 %s", blockName, info);
            }
            FullscreenEventHandler.moveEvent((ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), infoBuilder.build(), mousePosition);
            this.blockInfoStep.update(info, gridRenderer.getWidth() / 2, menuToolbarRect.getMinY());
        }
        return this.drawStepList;
    }

    private String getBlockInfo(BlockPos blockPos, String biomeName, RegionCoord regionCoord) {
        FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
        String region = "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
        this.locationFormatKeys = this.locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
        return this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), blockPos.m_123341_(), blockPos.m_123343_(), blockPos.m_123342_(), blockPos.m_123342_() >> 4) + " " + biomeName + " " + region;
    }

    @Override
    public List<DrawStep> onMouseClick(Minecraft mc, GridRenderer gridRenderer, Point2D.Double mousePosition, BlockPos blockCoord, int button, boolean doubleClick, float fontScale) {
        if (button == 1) {
            this.fullscreen.popupMenu.displayBasicOptions(blockCoord);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean propagateClick() {
        return true;
    }

    class BlockInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private double x;
        private double y;
        private String text;

        BlockInfoStep() {
        }

        void update(String text, double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            this.text = text;
            this.x = x;
            this.y = y - (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showMouseLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, this.text, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }

    class PlayerInfoStep
    implements DrawStep {
        private Theme.LabelSpec labelSpec;
        private String prefix;
        private double x;
        private double y;

        PlayerInfoStep() {
        }

        void update(double x, double y) {
            Theme theme = ThemeLoader.getCurrentTheme();
            this.labelSpec = theme.fullscreen.statusLabel;
            if (this.prefix == null) {
                this.prefix = BlockInfoLayer.this.mc.f_91074_.m_7755_().getString() + " \u25a0 ";
            }
            this.x = x;
            this.y = y + (double)theme.container.toolbar.horizontal.margin * BlockInfoLayer.this.fullscreen.getScreenScaleFactor();
        }

        @Override
        public void draw(PoseStack mStack, MultiBufferSource buffers, DrawStep.Pass pass, double xOffset, double yOffset, GridRenderer gridRenderer, double fontScale, double rotation) {
            if (pass == DrawStep.Pass.Text && JourneymapClient.getInstance().getFullMapProperties().showPlayerLoc.get().booleanValue()) {
                DrawUtil.drawLabel(mStack, this.prefix + Fullscreen.state().playerLastPos, this.labelSpec, this.x, this.y, DrawUtil.HAlign.Center, DrawUtil.VAlign.Below, fontScale, 0.0);
            }
        }

        @Override
        public int getDisplayOrder() {
            return 0;
        }

        @Override
        public String getModId() {
            return "journeymap";
        }
    }
}

