/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.theme;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.UIManager;
import journeymap.common.properties.config.StringField;
import net.minecraft.client.Minecraft;

public class ThemeLabelSource
implements StringField.ValuesProvider {
    public static final Map<String, InfoSlot> values = new HashMap<String, InfoSlot>();
    public static InfoSlot FPS = ThemeLabelSource.create("jm.theme.labelsource.fps", 10L, 1L, ThemeLabelSource::getFps);
    public static InfoSlot GameTime = ThemeLabelSource.create("jm.theme.labelsource.gametime", 0L, 500L, ThemeLabelSource::getGameTime);
    public static InfoSlot GameTimeReal = ThemeLabelSource.create("jm.theme.labelsource.gametime.real", 0L, 500L, ThemeLabelSource::getGameTimeReal);
    public static InfoSlot RealTime = ThemeLabelSource.create("jm.theme.labelsource.realtime", 0L, 500L, ThemeLabelSource::getRealTime);
    public static InfoSlot Location = ThemeLabelSource.create("jm.theme.labelsource.location", 100L, 1L, ThemeLabelSource::getLocation);
    public static InfoSlot Biome = ThemeLabelSource.create("jm.theme.labelsource.biome", 1000L, 1L, ThemeLabelSource::getBiome);
    public static InfoSlot Dimension = ThemeLabelSource.create("jm.theme.labelsource.dimension", 1000L, 1L, ThemeLabelSource::getDimension);
    public static InfoSlot Region = ThemeLabelSource.create("jm.theme.labelsource.region", 1000L, 1L, ThemeLabelSource::getRegion);
    public static InfoSlot LightLevel = ThemeLabelSource.create("jm.theme.labelsource.lightlevel", 100L, 100L, ThemeLabelSource::getLightLevel);
    public static InfoSlot Blank = ThemeLabelSource.create("jm.theme.labelsource.blank", 0L, 1L, () -> "");

    public static InfoSlot create(String key, long cacheMillis, long granularityMillis, Supplier<String> supplier) {
        InfoSlot slot = new InfoSlot(key, cacheMillis, granularityMillis, supplier);
        values.put(key, slot);
        return slot;
    }

    public static InfoSlot create(String modId, String key, long cacheMillis, long granularityMillis, Supplier<String> supplier) {
        InfoSlot slot = new InfoSlot(modId, key, cacheMillis, granularityMillis, supplier);
        values.put(key, slot);
        return slot;
    }

    public static void resetCaches() {
        for (InfoSlot source : values.values()) {
            source.lastCallTime = 0L;
            source.lastValue = "";
        }
    }

    @Override
    public List<String> getStrings() {
        return values.values().stream().map(infoSlot -> infoSlot.key).collect(Collectors.toList());
    }

    @Override
    public String getDefaultString() {
        return null;
    }

    private static String getFps() {
        return Minecraft.f_91021_ + " fps";
    }

    private static String getGameTime() {
        return WorldData.getGameTime();
    }

    private static String getGameTimeReal() {
        return WorldData.getRealGameTime();
    }

    private static String getRealTime() {
        return WorldData.getSystemTime();
    }

    private static String getLocation() {
        return UIManager.INSTANCE.getMiniMap().getLocation();
    }

    private static String getBiome() {
        return UIManager.INSTANCE.getMiniMap().getBiome();
    }

    private static String getDimension() {
        return WorldData.getDimension();
    }

    private static String getLightLevel() {
        return WorldData.getLightLevel();
    }

    private static String getRegion() {
        return WorldData.getRegion();
    }

    public static class InfoSlot {
        private final String key;
        private final String modId;
        private final Supplier<String> supplier;
        private final long cacheMillis;
        private final long granularityMillis;
        private long lastCallTime;
        private String lastValue = "";

        public InfoSlot(String key, long cacheMillis, long granularityMillis, Supplier<String> supplier) {
            this.key = key;
            this.modId = "";
            this.supplier = supplier;
            this.cacheMillis = cacheMillis;
            this.granularityMillis = granularityMillis;
        }

        public InfoSlot(String modId, String key, long cacheMillis, long granularityMillis, Supplier<String> supplier) {
            this.key = key;
            this.modId = modId;
            this.supplier = supplier;
            this.cacheMillis = cacheMillis;
            this.granularityMillis = granularityMillis;
        }

        public String getLabelText(long currentTimeMillis) {
            try {
                long now = this.granularityMillis * (currentTimeMillis / this.granularityMillis);
                if (now - this.lastCallTime <= this.cacheMillis) {
                    return this.lastValue;
                }
                this.lastCallTime = now;
                this.lastValue = this.supplier.get();
                return this.lastValue;
            }
            catch (Exception e) {
                return "?";
            }
        }

        public boolean isShown() {
            if (Minecraft.m_91087_().f_91073_ != null) {
                return this != Blank && this.supplier != null && this.supplier.get() != null && !this.supplier.get().isEmpty() && !"".equals(this.supplier.get());
            }
            return false;
        }

        public String getTooltip() {
            if (!Constants.getString(this.key + ".tooltip").equals(this.key + ".tooltip")) {
                String prefix = this.modId + ":";
                if ("".equals(this.modId)) {
                    return Constants.getString(this.key + ".tooltip");
                }
                return prefix + Constants.getString(this.key + ".tooltip");
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }
    }
}

