/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.world;

import com.google.common.cache.CacheLoader;
import journeymap.client.data.DataCache;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.model.ChunkMD;
import journeymap.client.world.CustomListeners;
import journeymap.client.world.listener.WorldRenderEventListener;
import journeymap.common.Journeymap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkMonitor
implements WorldRenderEventListener,
EventHandlerManager.EventHandler {
    private LevelAccessor world;
    private static ChunkMonitor instance;
    private CustomListeners listeners = CustomListeners.getInstance();

    private ChunkMonitor() {
    }

    public static ChunkMonitor getInstance() {
        if (instance == null) {
            instance = new ChunkMonitor();
        }
        return instance;
    }

    public void reset() {
        if (this.world != null) {
            this.listeners.removeWorldRenderEventListener(this);
        }
        this.world = null;
    }

    public void resetRenderTimes(ChunkPos pos) {
        ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(pos);
        if (chunkMD != null) {
            chunkMD.resetRenderTimes();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        LevelChunk chunk;
        if (event.getWorld() == null || !event.getWorld().m_5776_()) {
            return;
        }
        if (this.world == null) {
            this.world = event.getWorld();
            this.listeners.addWorldRenderEventListener(this);
            event.getWorld();
        }
        if ((chunk = (LevelChunk)event.getChunk()) != null && chunk.f_62775_) {
            DataCache.INSTANCE.addChunkMD(new ChunkMD(chunk));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        try {
            LevelAccessor world = event.getWorld();
            if (world.equals(this.world)) {
                this.reset();
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error handling WorldEvent.Unload", (Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onBlockUpdate(BlockEvent event) {
        if (event.getWorld() != null) {
            int chunkX = new ChunkPos((BlockPos)event.getPos()).f_45578_;
            int chunkZ = new ChunkPos((BlockPos)event.getPos()).f_45579_;
            this.markBlockRangeForRenderUpdate(chunkX * 16, chunkZ * 16, chunkX * 16 + 15, chunkZ * 16 + 15);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onChunkUpdate(ChunkWatchEvent event) {
        if (event.getWorld() != null) {
            this.resetRenderTimes(event.getPos());
        }
    }

    @Override
    public void onWorldRenderEvent(int x, int z, int y) {
        this.resetRenderTimes(new ChunkPos(x, z));
    }

    private void markBlockRangeForRenderUpdate(int x1, int z1, int x2, int z2) {
        int cx1 = x1 >> 4;
        int cz1 = z1 >> 4;
        int cx2 = x2 >> 4;
        int cz2 = z2 >> 4;
        if (cx1 == cx2 && cz1 == cz2) {
            this.resetRenderTimes(new ChunkPos(cx1, cz1));
        } else {
            for (int chunkXPos = cx1; chunkXPos < cx2; ++chunkXPos) {
                for (int chunkZPos = cz1; chunkZPos < cz2; ++chunkZPos) {
                    this.resetRenderTimes(new ChunkPos(chunkXPos, chunkZPos));
                }
            }
        }
    }

    private static class TimestampLoader
    extends CacheLoader<ChunkPos, Long> {
        private TimestampLoader() {
        }

        public Long load(ChunkPos key) throws Exception {
            return System.currentTimeMillis();
        }
    }
}

