/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.model.BlockDataArrays;
import journeymap.client.model.MapType;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;

public class ChunkData {
    private static final String BIOME_TAG_NAME = "biome_name";
    private static final String BLOCK_TAG_NAME = "block";
    private static final String TOP_Y_TAG_NAME = "top_y";
    private final MapType mapType;
    private final ChunkPos chunkPos;
    private final boolean enabled;
    private final BlockDataArrays blockDataArrays;

    public ChunkData(MapType mapType, ChunkPos chunkPos, boolean enabled) {
        this.enabled = enabled;
        this.mapType = mapType;
        this.chunkPos = chunkPos;
        this.blockDataArrays = new BlockDataArrays();
    }

    private ChunkData(MapType mapType, ChunkPos chunkPos, boolean enabled, BlockDataArrays blockDataArrays) {
        this.enabled = enabled;
        this.mapType = mapType;
        this.chunkPos = chunkPos;
        this.blockDataArrays = blockDataArrays;
    }

    public static ChunkData from(ChunkData data) {
        return new ChunkData(data.mapType, data.chunkPos, data.enabled, data.blockDataArrays);
    }

    public void setBiome(int x, int z, Biome biome) {
        if (this.enabled) {
            String biomeString = BiomeHelper.getBiomeResource(biome).toString();
            this.blockDataArrays.get(this.mapType).objects().set(BIOME_TAG_NAME, x, z, biomeString);
        }
    }

    public Object getBiome(int x, int z) {
        return this.blockDataArrays.get(this.mapType).objects().get(BIOME_TAG_NAME, x, z);
    }

    public void setBlock(int x, int z, Block block) {
        if (this.enabled) {
            String blockValue = block.getRegistryName().toString();
            this.blockDataArrays.get(this.mapType).objects().set(BLOCK_TAG_NAME, x, z, blockValue);
        }
    }

    public Object getBlock(int x, int z) {
        return this.blockDataArrays.get(this.mapType).objects().get(BLOCK_TAG_NAME, x, z);
    }

    public void setY(int x, int z, int topY) {
        if (this.enabled) {
            this.blockDataArrays.get(this.mapType).ints().set(TOP_Y_TAG_NAME, x, z, topY);
        }
    }

    public Integer getY(int x, int z) {
        return this.blockDataArrays.get(this.mapType).ints().get(TOP_Y_TAG_NAME, x, z);
    }

    public void setBlockColor(int x, int z, int color, MapType.Name mapTypeName) {
        if (this.enabled) {
            this.blockDataArrays.get(this.mapType).ints().set(mapTypeName.name(), x, z, color);
        }
    }

    public Integer getBlockColor(int x, int z, MapType.Name mapTypeName) {
        return this.blockDataArrays.get(this.mapType).ints().get(mapTypeName.name(), x, z);
    }

    public BlockDataArrays getBlockDataArrays() {
        return this.blockDataArrays;
    }

    public MapType getMapType() {
        return this.mapType;
    }

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public void clear() {
        this.blockDataArrays.clearAll();
    }
}

