/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class RegionData {
    private static final String BIOME_TAG_NAME = "biome_name";
    private static final String BLOCK_TAG_NAME = "block";
    private static final String TOP_Y_TAG_NAME = "top_y";
    private static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    private boolean dirty = false;
    protected CompoundTag data;
    protected final Map<ChunkPos, CompoundTag> chunkMap = new HashMap<ChunkPos, CompoundTag>();
    protected File dataFile;
    protected boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;

    public RegionData(RegionDataStorageHandler.Key key) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
        RegionDataStorageHandler.getInstance().load(this, key.asyncLoad);
    }

    public Biome getBiome(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && this.data != null && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BIOME_TAG_NAME)) {
            String biomeName = blockData.m_128461_(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && this.data != null && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(TOP_Y_TAG_NAME)) {
            return blockData.m_128451_(TOP_Y_TAG_NAME);
        }
        return blockPos.m_123342_();
    }

    public Integer getColor(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && this.data != null && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BLOCK_COLOR_TAG_NAME)) {
            return blockData.m_128451_(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public Block getBlock(BlockPos blockPos) {
        CompoundTag blockData;
        if (this.enabled && this.data != null && (blockData = this.getBlockDataFromBlockPos(blockPos)).m_128441_(BLOCK_TAG_NAME)) {
            String blockRegName = blockData.m_128461_(BLOCK_TAG_NAME);
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockRegName));
        }
        return null;
    }

    public void setBiome(CompoundTag blockData, String biomeString) {
        if (this.enabled && this.data != null) {
            String biomeName;
            if (blockData.m_128441_(BIOME_TAG_NAME) && (biomeName = blockData.m_128461_(BIOME_TAG_NAME)).equals(biomeString)) {
                return;
            }
            blockData.m_128359_(BIOME_TAG_NAME, biomeString);
            this.setDirty(true);
        }
    }

    public void setBlock(CompoundTag blockData, String blockValue) {
        if (this.enabled && this.data != null) {
            String biomeName;
            if (blockData.m_128441_(BLOCK_TAG_NAME) && (biomeName = blockData.m_128461_(BLOCK_TAG_NAME)).equals(blockValue)) {
                return;
            }
            blockData.m_128359_(BLOCK_TAG_NAME, blockValue);
            this.setDirty(true);
        }
    }

    public void setY(CompoundTag blockData, int topY) {
        if (this.enabled && this.data != null) {
            int savedTopY;
            if (blockData.m_128441_(TOP_Y_TAG_NAME) && (savedTopY = blockData.m_128451_(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.m_128405_(TOP_Y_TAG_NAME, topY);
            this.setDirty(true);
        }
    }

    public void setBlockColor(CompoundTag blockData, int color, MapType.Name mapTypeName) {
        if (this.enabled && this.data != null) {
            int savedColor;
            if (blockData.m_128441_(BLOCK_COLOR_TAG_NAME + mapTypeName.name()) && (savedColor = blockData.m_128451_(BLOCK_COLOR_TAG_NAME + mapTypeName.name())) == color) {
                return;
            }
            blockData.m_128405_(BLOCK_COLOR_TAG_NAME + mapTypeName.name(), color);
            this.setDirty(true);
        }
    }

    public CompoundTag getBlockDataFromBlockPos(ChunkPos chunkPos, CompoundTag chunk, int x, int z) {
        if (this.enabled && chunk != null && this.data != null) {
            return this.getBlockDataForChunk(chunk, (chunkPos.f_45578_ << 4) + x, (chunkPos.f_45579_ << 4) + z);
        }
        return null;
    }

    private CompoundTag getBlockDataFromBlockPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CompoundTag chunk = this.getChunkNbt(chunkPos);
        return this.getBlockDataForChunk(chunk, pos.m_123341_(), pos.m_123343_());
    }

    public CompoundTag getChunkNbt(ChunkPos chunkPos) {
        if (this.enabled && this.data != null) {
            CompoundTag chunkTag = this.chunkMap.get(chunkPos);
            if (chunkTag == null) {
                String chunkTagName = chunkPos.f_45578_ + "," + chunkPos.f_45579_;
                if (this.data.m_128441_(chunkTagName)) {
                    chunkTag = this.data.m_128469_(chunkTagName);
                } else {
                    chunkTag = new CompoundTag();
                    this.data.m_128365_(chunkTagName, (Tag)chunkTag);
                }
                this.chunkMap.put(chunkPos, chunkTag);
            }
            return chunkTag;
        }
        return null;
    }

    private CompoundTag getBlockDataForChunk(CompoundTag chunk, int x, int z) {
        if (chunk != null) {
            CompoundTag blockTag;
            String blockTagName = x + "," + z;
            if (chunk.m_128441_(blockTagName)) {
                blockTag = chunk.m_128469_(blockTagName);
            } else {
                blockTag = new CompoundTag();
                chunk.m_128365_(blockTagName, (Tag)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setData(CompoundTag data) {
        this.data = data;
    }

    public void clear() {
        Journeymap.getLogger().debug("Flushing {}", (Object)this.regionCoord.toString());
        this.chunkMap.clear();
        this.data = null;
        this.dataFile = null;
    }
}

