/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.model.BlockDataArrays;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageSet;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.common.Journeymap;
import journeymap.common.nbt.ChunkData;
import journeymap.common.nbt.RegionData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class RegionDataStorageHandler {
    public static final long MAX_CACHE_SIZE = 5L;
    public long firstFileFlushIntervalSecs = 5L;
    public long saveFileIntervalSecs = 10L;
    private volatile long lastSave = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.firstFileFlushIntervalSecs);
    private volatile Map<Key, RegionData> dataMap = new LinkedHashMap<Key, RegionData>();
    private RegionData lastHandler;
    private static RegionDataStorageHandler INSTANCE;

    public static RegionDataStorageHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RegionDataStorageHandler();
        }
        return INSTANCE;
    }

    public void save(RegionData regionData) {
        if (regionData.isDirty() && regionData.enabled) {
            File file = this.getFile(regionData);
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128365_("data", (Tag)regionData.data);
            compoundtag.m_128359_("version", Journeymap.JM_VERSION.toString());
            try {
                try {
                    NbtIo.m_128944_((CompoundTag)compoundtag, (File)file);
                    regionData.clear();
                    compoundtag.m_128473_("data");
                }
                catch (IOException ioe) {
                    Journeymap.getLogger().error("Could not save region data cache {}", (Object)this, (Object)ioe);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Could not save region cache async {}", (Object)this, (Object)e);
            }
            regionData.setDirty(false);
        }
    }

    public File getDir(RegionCoord rCoord) {
        File dimDir = rCoord.dimDir.toFile();
        if (!dimDir.exists()) {
            dimDir.mkdirs();
        }
        return dimDir;
    }

    @Nullable
    private File getFile(RegionData regionData) {
        if (regionData.dataFile == null) {
            File cacheDirectory;
            File directory = this.getDir(regionData.regionCoord);
            if (regionData.mapType.isUnderground() || Level.f_46429_.equals(regionData.mapType.dimension)) {
                if (regionData.mapType.vSlice == null) {
                    return null;
                }
                directory = new File(directory, regionData.mapType.vSlice.toString());
            }
            if (!(cacheDirectory = new File(directory, "cache")).exists()) {
                cacheDirectory.mkdirs();
            }
            regionData.dataFile = new File(cacheDirectory, regionData.regionCoord.regionX + "," + regionData.regionCoord.regionZ + ".dat");
        }
        return regionData.dataFile;
    }

    public void load(RegionData regionData, boolean async) {
        if (!regionData.loaded) {
            if (async) {
                try {
                    JourneymapClient.getInstance().queueOneOff(() -> regionData.setData(this.load(regionData)));
                }
                catch (Exception e) {
                    Journeymap.getLogger().error("Could not load region cache async {}", (Object)this, (Object)e);
                }
            } else {
                regionData.setData(this.load(regionData));
            }
            regionData.loaded = true;
        }
    }

    private CompoundTag load(RegionData regionData) {
        if (regionData.enabled) {
            File file = this.getFile(regionData);
            if (file != null && file.exists()) {
                try {
                    CompoundTag compoundTagRaw = NbtIo.m_128937_((File)file);
                    return compoundTagRaw.m_128469_("data");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (file != null) {
                return new CompoundTag();
            }
        }
        return null;
    }

    public RegionData getRegionDataAsyncNoCache(RegionCoord regionCoord, MapType mapType) {
        if (MapRegionTask.active) {
            return null;
        }
        Key key = new Key(regionCoord, mapType, true);
        if (this.lastHandler != null && key.equals(this.lastHandler.key)) {
            return this.lastHandler;
        }
        if (this.dataMap.containsKey(key)) {
            return this.dataMap.get(key);
        }
        this.lastHandler = new RegionData(key);
        return this.lastHandler;
    }

    public RegionData getRegionDataAsyncNoCache(BlockPos blockPos, MapType mapType) {
        RegionCoord regionCoord = RegionCoord.fromChunkPos(FileHandler.getJMWorldDir(Minecraft.m_91087_()), mapType, blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4);
        return this.getRegionDataAsyncNoCache(regionCoord, mapType);
    }

    public void saveAndFlush(Map<Key, Set<ChunkData>> chunkMap, boolean enabled, boolean force) {
        if (this.lastSave + TimeUnit.SECONDS.toMillis(this.saveFileIntervalSecs) < System.currentTimeMillis() || (long)chunkMap.size() >= 5L || force) {
            if (enabled) {
                Stopwatch timer = Stopwatch.createStarted();
                chunkMap.keySet().forEach(key -> {
                    RegionData data = new RegionData((Key)key);
                    ((Set)chunkMap.get(key)).forEach(chunkData -> {
                        this.buildRegionDataFromChunk(data, (ChunkData)chunkData);
                        chunkData.clear();
                    });
                    chunkMap.remove(key);
                    this.save(data);
                    this.lastSave = System.currentTimeMillis();
                });
            } else {
                chunkMap.clear();
            }
        }
    }

    private void buildRegionDataFromChunk(RegionData data, ChunkData chunkData) {
        CompoundTag chunkNbt = data.getChunkNbt(chunkData.getChunkPos());
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                Integer y;
                CompoundTag blockNbt = data.getBlockDataFromBlockPos(chunkData.getChunkPos(), chunkNbt, x, z);
                Object biome = chunkData.getBiome(x, z);
                if (biome != null) {
                    data.setBiome(blockNbt, biome.toString());
                }
                Object block = chunkData.getBlock(x, z);
                if (biome != null) {
                    data.setBlock(blockNbt, block.toString());
                }
                if ((y = chunkData.getY(x, z)) != null) {
                    data.setY(blockNbt, y);
                }
                if (data.key.mapType.isSurfaceType()) {
                    MapType.Name name;
                    BlockDataArrays.DataArray<Integer> ints = chunkData.getBlockDataArrays().get(chunkData.getMapType()).ints();
                    if (ints.has(MapType.Name.day.name())) {
                        name = MapType.Name.day;
                        data.setBlockColor(blockNbt, chunkData.getBlockColor(x, z, name), name);
                    }
                    if (ints.has(MapType.Name.night.name())) {
                        name = MapType.Name.night;
                        data.setBlockColor(blockNbt, chunkData.getBlockColor(x, z, name), name);
                    }
                    if (ints.has(MapType.Name.biome.name())) {
                        name = MapType.Name.biome;
                        data.setBlockColor(blockNbt, chunkData.getBlockColor(x, z, name), name);
                    }
                    if (!ints.has(MapType.Name.topo.name())) continue;
                    name = MapType.Name.topo;
                    data.setBlockColor(blockNbt, chunkData.getBlockColor(x, z, name), name);
                    continue;
                }
                if (!data.key.mapType.isUnderground()) continue;
                MapType.Name name = MapType.Name.underground;
                data.setBlockColor(blockNbt, chunkData.getBlockColor(x, z, name), name);
            }
        }
    }

    public static class Key {
        final RegionCoord rCoord;
        final MapType mapType;
        final boolean asyncLoad;

        public Key(RegionCoord rCoord, MapType mapType, boolean asyncLoad) {
            this.rCoord = rCoord;
            this.mapType = mapType;
            this.asyncLoad = asyncLoad;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.mapType.dimension.equals(key.mapType.dimension)) {
                return false;
            }
            if (this.mapType.isUnderground() != key.mapType.isUnderground()) {
                return false;
            }
            if (this.mapType.isSurfaceType() != key.mapType.isSurfaceType()) {
                return false;
            }
            if (this.rCoord.regionX != key.rCoord.regionX) {
                return false;
            }
            return this.rCoord.regionZ == key.rCoord.regionZ;
        }

        public int hashCode() {
            int result = 31 + this.rCoord.regionX;
            result = 31 * result + this.rCoord.regionZ;
            result = 31 * result + this.mapType.dimension.hashCode();
            return result;
        }

        public String toString() {
            return new StringJoiner(", ", RegionImageSet.Key.class.getSimpleName() + "[", "]").add("isUnderground=" + this.mapType.isUnderground()).add("isSurfaceType=" + this.mapType.isSurfaceType()).add("rCoord=" + this.rCoord).add("regionX=" + this.rCoord.regionX).add("regionZ=" + this.rCoord.regionZ).add("dimension=" + this.mapType.dimension).toString();
        }
    }
}

