/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.forge;

import java.util.function.Supplier;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerAdminRequestPropPacket {
    private Integer type;
    private String payload;
    private String dimension;

    public ServerAdminRequestPropPacket() {
    }

    public ServerAdminRequestPropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public ServerAdminRequestPropPacket(Integer type, String dimension) {
        this(type, "", dimension);
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public ServerAdminRequestPropPacket(FriendlyByteBuf buf) {
        try {
            if (buf.capacity() > 1) {
                buf.readByte();
                this.type = buf.readInt();
                this.dimension = buf.m_130136_(Short.MAX_VALUE);
                this.payload = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for server admin request: %s", t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.m_130070_(this.dimension);
                buf.m_130070_(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for server admin request:" + t);
        }
    }

    public static void handle(ServerAdminRequestPropPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Journeymap.getInstance().getPacketHandler().onAdminScreenOpen(((NetworkEvent.Context)ctx.get()).getSender(), packet.getType(), packet.dimension);
            } else {
                JourneymapClient.getInstance().getPacketHandler().onServerAdminDataResponse(packet.getType(), packet.getPayload(), packet.dimension);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

