/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.util.List;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.config.ForgeConfig;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.PermissionProperties;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.properties.ServerOption;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLLoader;

public class PermissionsManager {
    private static PermissionsManager INSTANCE;

    public static PermissionsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PermissionsManager();
        }
        return INSTANCE;
    }

    public void sendPermissions(ServerPlayer playerEntity) {
        GlobalProperties permissions = this.getPlayerConfig(playerEntity);
        if (permissions != null) {
            Journeymap.getInstance().getDispatcher().sendClientPermissions(playerEntity, permissions.toJsonString(false), this.canServerAdmin(playerEntity));
        }
    }

    private GlobalProperties getPlayerConfig(ServerPlayer player) {
        if (PropertiesManager.getInstance().getGlobalProperties().useWorldId.get().booleanValue() && (FMLLoader.getDist().isDedicatedServer() || Minecraft.m_91087_().m_91092_() != null && Minecraft.m_91087_().m_91092_().m_6992_())) {
            String worldId = WorldIdData.getWorldId();
            Journeymap.getInstance().getDispatcher().sendWorldIdPacket(player, worldId);
        }
        return this.buildPermissions(player);
    }

    public boolean canServerAdmin(ServerPlayer player) {
        List admins = (List)ForgeConfig.serverAdmins.get();
        for (String admin : admins) {
            if (!player.m_142081_().toString().equals(admin) && !player.m_7755_().getString().equalsIgnoreCase(admin) && !CommonConstants.debugOverride((Entity)player)) continue;
            return true;
        }
        if (Journeymap.isOp((Player)player)) {
            return (Boolean)ForgeConfig.opAccess.get();
        }
        return false;
    }

    private boolean canTeleport(ServerPlayer player) {
        ResourceKey<Level> playerDim = DimensionHelper.getDimension((Entity)player);
        if (PropertiesManager.getInstance().getDimProperties(playerDim).enabled.get().booleanValue()) {
            return PropertiesManager.getInstance().getDimProperties(playerDim).teleportEnabled.get();
        }
        if (PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get().booleanValue()) {
            return true;
        }
        return Journeymap.isOp((Player)player);
    }

    private GlobalProperties buildPermissions(ServerPlayer player) {
        PermissionProperties prop = PropertiesManager.getInstance().getDimProperties((ResourceKey<Level>)player.m_20193_().m_46472_());
        GlobalProperties globalProp = PropertiesManager.getInstance().getGlobalProperties();
        boolean isOp = Journeymap.isOp((Player)player);
        if (!((DimensionProperties)prop).enabled.get().booleanValue()) {
            prop = globalProp;
        }
        GlobalProperties to = (GlobalProperties)new GlobalProperties().loadForClient(prop.toJsonString(true), true);
        to.journeymapEnabled.set(globalProp.journeymapEnabled.get() != false || isOp || CommonConstants.debugOverride((Entity)player));
        to.teleportEnabled.set(this.canTeleport(player));
        to.worldPlayerRadar.set(((ServerOption)globalProp.worldPlayerRadar.get()).enabled(isOp));
        to.radarEnabled.set(((ServerOption)prop.radarEnabled.get()).enabled(isOp));
        to.surfaceMapping.set(((ServerOption)prop.surfaceMapping.get()).enabled(isOp));
        to.topoMapping.set(((ServerOption)prop.topoMapping.get()).enabled(isOp));
        to.caveMapping.set(((ServerOption)prop.caveMapping.get()).enabled(isOp));
        return to;
    }
}

