/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.entity.ai.LookAtTradingPlayerGoal;
import ovh.corail.tombstone.entity.ai.TradeWithPlayerGoal;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemLollipop;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class AbstractMerchant
extends PathfinderMob
implements Merchant {
    private static final EntityDataAccessor<Byte> TRADE_LEVEL = SynchedEntityData.m_135353_(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> TRADE_XP = SynchedEntityData.m_135353_(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    protected Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    protected long lastRestockGameTime;
    private static final int UPDATE_VERSION = 1;
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES;
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> HALLOWEEN_TRADES;
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> CHRISTMAS_TRADES;

    public AbstractMerchant(EntityType<? extends AbstractMerchant> merchant, Level level) {
        super(merchant, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRADE_LEVEL, (Object)1);
        this.f_19804_.m_135372_(TRADE_XP, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new TradeWithPlayerGoal<AbstractMerchant>(this));
        this.f_21345_.m_25352_(1, new LookAtTradingPlayerGoal<AbstractMerchant>(this));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public Level m_183503_() {
        return this.f_19853_;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.initTrades();
        }
        return this.offers;
    }

    private void initTrades() {
        this.offers = new MerchantOffers();
        this.addBasicTrades(TradeType.COMMON, 6);
        int tradeLevel = this.getTradeLevel();
        if (tradeLevel > 1) {
            this.addBasicTrades(TradeType.UNCOMMON, tradeLevel);
        }
        if (tradeLevel > 3) {
            this.addBasicTrades(TradeType.RARE, tradeLevel - 2);
        }
        if (TimeHelper.isDateAroundHalloween()) {
            this.addHalloweenTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addHalloweenTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addHalloweenTrades(TradeType.RARE);
            }
        }
        if (TimeHelper.isDateAroundChristmas()) {
            this.addChristmasTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addChristmasTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addChristmasTrades(TradeType.RARE);
            }
        }
    }

    private void addBasicTrades(TradeType tradeType, int toAdd) {
        Optional.ofNullable(tradeType.getBasicTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, toAdd));
    }

    private void addHalloweenTrades(TradeType tradeType) {
        Optional.ofNullable(tradeType.getHalloweenTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addChristmasTrades(TradeType tradeType) {
        Optional.ofNullable(tradeType.getChristmasTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addTrades(VillagerTrades.ItemListing[] trades, int toAdd) {
        if (toAdd >= trades.length) {
            Arrays.stream(trades).map(trade -> trade.m_5670_((Entity)this, this.f_19796_)).filter(Objects::nonNull).forEach(arg_0 -> this.m_6616_().add(arg_0));
        } else {
            List ids = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
            Collections.shuffle(ids, this.f_19796_);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                MerchantOffer offer = trades[id].m_5670_((Entity)this, this.f_19796_);
                if (offer == null) continue;
                this.m_6616_().add((Object)offer);
                if (--toAdd > 0) continue;
                break;
            }
        }
    }

    public void m_6255_(MerchantOffers offers) {
    }

    public void m_6621_(int xp) {
    }

    public void m_7713_(ItemStack stack) {
        if (!this.f_19853_.f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(stack.m_41619_() ? SoundEvents.f_12382_ : SoundEvents.f_12383_, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (EntityHelper.isValidServerPlayer(this.tradingPlayer)) {
            ServerPlayer player = (ServerPlayer)this.tradingPlayer;
            assert (player != null);
            ModTriggers.TRADE_GRAVE_GUARDIAN.trigger(player);
            boolean isFirstSlot = offer.m_45352_().m_150930_((Item)ModItems.lollipop);
            if (isFirstSlot || offer.m_45364_().m_150930_((Item)ModItems.lollipop)) {
                ModTriggers.TRADE_LOLLIPOP.trigger(player, (isFirstSlot ? offer.m_45352_() : offer.m_45364_()).m_41613_());
                if (offer.m_45368_().m_150930_((Item)ModItems.essence_of_undeath)) {
                    ModTriggers.TRADE_LOLLIPOP_FOR_ESSENCE.trigger(player);
                }
            }
        }
        this.f_21363_ = -this.m_8100_();
        boolean isLevelUp = this.increaseLevel(offer.m_45379_());
        if (offer.m_45383_()) {
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), this.f_19796_.nextInt(4) + (isLevelUp ? 8 : 3)));
        }
    }

    private boolean increaseLevel(int offerXp) {
        int tradeLevel = this.getTradeLevel();
        this.setVillagerXp(this.m_7809_() + offerXp);
        if (tradeLevel < 5 && this.m_7809_() >= VillagerData.m_35577_((int)tradeLevel)) {
            int newTradeLevel = tradeLevel + 1;
            this.setTradeLevel(newTradeLevel);
            this.initTrades();
            Optional.ofNullable(this.m_7962_()).ifPresent(player -> player.m_7662_(player.f_36096_.f_38840_, this.m_6616_(), newTradeLevel, this.m_7809_(), this.m_7826_(), this.m_7862_()));
            return true;
        }
        return false;
    }

    @Nullable
    public Entity changeDimension(ServerLevel level, ITeleporter teleporter) {
        this.m_7189_(null);
        return super.changeDimension(level, teleporter);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.m_7189_(null);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && this.tradingPlayer == null) {
            if (hand == InteractionHand.MAIN_HAND && EntityHelper.isValidServerPlayer(player)) {
                ModTriggers.TALK_GRAVE_GUARDIAN.trigger((ServerPlayer)player);
            }
            if (!(this.f_19853_.f_46443_ || this.m_6616_().isEmpty() || EntityHelper.targetAnEnemy((LivingEntity)this))) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.getTradeLevel());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public int m_7809_() {
        return (Integer)this.f_19804_.m_135370_(TRADE_XP);
    }

    public void setVillagerXp(int tradeXp) {
        this.f_19804_.m_135381_(TRADE_XP, (Object)tradeXp);
    }

    public int getTradeLevel() {
        return (Byte)this.f_19804_.m_135370_(TRADE_LEVEL) & 0xFF;
    }

    public void setTradeLevel(int tradeLevel) {
        this.f_19804_.m_135381_(TRADE_LEVEL, (Object)((byte)tradeLevel));
    }

    public boolean m_7826_() {
        return true;
    }

    public boolean m_7862_() {
        return true;
    }

    public boolean m_183595_() {
        return this.f_19853_.f_46443_;
    }

    public void restock() {
        for (MerchantOffer offer : this.m_6616_()) {
            boolean hasImpregnatedDiamondA = offer.m_45352_().m_150930_((Item)ModItems.impregnated_diamond);
            boolean hasImpregnatedDiamondB = offer.m_45364_().m_150930_((Item)ModItems.impregnated_diamond);
            if ((hasImpregnatedDiamondA || hasImpregnatedDiamondB) && (offer.m_45371_() > 0 || this.f_19796_.nextInt(31) == 0)) {
                if (hasImpregnatedDiamondA) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.m_45352_());
                }
                if (hasImpregnatedDiamondB) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.m_45364_());
                }
            }
            if (offer.m_45352_().m_150930_((Item)ModItems.lollipop) && this.f_19796_.nextInt(31) == 0) {
                ModItems.lollipop.setColor(offer.m_45352_(), ItemLollipop.ModelColor.getRandom());
            }
            offer.m_45372_();
        }
    }

    public void m_8119_() {
        long worldTicks;
        super.m_8119_();
        if (!this.f_19853_.m_5776_() && this.tradingPlayer == null && this.m_7862_() && TimeHelper.minuteElapsed(worldTicks = TimeHelper.worldTicks(this.f_19853_), this.lastRestockGameTime) >= 60L) {
            this.lastRestockGameTime = worldTicks + (long)TimeHelper.tickFromHour(1);
            this.restock();
        }
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_144211_;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("special_event", (short)TimeHelper.getSpecialEvent().ordinal());
        compound.m_128376_("update_version", (short)1);
        MerchantOffers offers = this.m_6616_();
        if (!offers.isEmpty()) {
            compound.m_128365_("Offers", (Tag)offers.m_45388_());
        }
        compound.m_128344_("trade_level", ((Byte)this.f_19804_.m_135370_(TRADE_LEVEL)).byteValue());
        compound.m_128405_("trade_xp", this.m_7809_());
        compound.m_128356_("last_restock", this.lastRestockGameTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadOffers(compound);
        if (compound.m_128425_("trade_level", 1)) {
            this.setTradeLevel(compound.m_128445_("trade_level"));
        }
        if (compound.m_128425_("trade_xp", 3)) {
            this.setVillagerXp(compound.m_128451_("trade_xp"));
        }
        if (compound.m_128425_("last_restock", 4)) {
            this.lastRestockGameTime = compound.m_128454_("last_restock");
        }
    }

    private void loadOffers(CompoundTag compound) {
        if (compound.m_128425_("special_event", 2) && TimeHelper.getSpecialEvent() != TimeHelper.SpecialEvent.byId(compound.m_128448_("special_event"))) {
            this.offers = null;
        } else if (compound.m_128425_("update_version", 2) && 1 != compound.m_128448_("update_version")) {
            this.offers = null;
        } else if (compound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compound.m_128469_("Offers"));
            for (MerchantOffer offer : this.offers) {
                IDisableable disableable;
                ItemStack buy2;
                Item item;
                IDisableable disableable2;
                ItemStack buy1 = offer.m_45352_();
                Item item2 = buy1.m_41720_();
                if (item2 instanceof IDisableable && !(disableable2 = (IDisableable)item2).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (buy1.m_150930_((Item)ModItems.impregnated_diamond) && ModItems.impregnated_diamond.getEntityType(buy1).isEmpty()) {
                    ModItems.impregnated_diamond.withRandomImpregnation(buy1);
                }
                if ((item = (buy2 = offer.m_45364_()).m_41720_()) instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (!buy2.m_150930_((Item)ModItems.impregnated_diamond) || !ModItems.impregnated_diamond.getEntityType(buy2).isEmpty()) continue;
                ModItems.impregnated_diamond.withRandomImpregnation(buy2);
            }
        }
    }

    static {
        VillagerTrades.ItemListing[] itemListingArray = new VillagerTrades.ItemListing[8];
        itemListingArray[0] = new TradeForItems(() -> new ItemStack((ItemLike)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_slab : ModBlocks.dark_marble_slab), 64), ModItems.tablet_of_recall::createAncient, 1, 10);
        itemListingArray[1] = new TradeForItems(() -> new ItemStack((ItemLike)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_slab : ModBlocks.dark_marble_slab), 64), ModItems.tablet_of_home::createAncient, 1, 10);
        itemListingArray[2] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42716_, 5), () -> ModItems.voodoo_poppet.createWithRandomProtections(6), 1, 10);
        itemListingArray[3] = new TradeForItems(() -> ModItems.impregnated_diamond.withRandomImpregnation(new ItemStack((ItemLike)ModItems.impregnated_diamond)), () -> new ItemStack((ItemLike)ModItems.grave_dust, 30), 1, 10);
        itemListingArray[4] = new TradeForItems(() -> new ItemStack((ItemLike)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_wall : ModBlocks.dark_marble_wall), 64), () -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 15);
        itemListingArray[5] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42679_, 30), () -> new ItemStack((ItemLike)ModItems.soul_receptacle), 1, 15);
        itemListingArray[6] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_151057_), () -> NBTStackHelper.setBoolean(NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.fishing_rod_of_misadventure), "ancient", true), "enchant", true), 1, 10);
        itemListingArray[7] = new TradeForItems(() -> {
            ItemStack familiarReceptacle = new ItemStack((ItemLike)ModItems.familiar_receptacle);
            CompoundTag deadPetTag = new CompoundTag();
            deadPetTag.m_128359_("id", Helper.RANDOM.nextBoolean() ? "minecraft:skeleton_horse" : "minecraft:zombie_horse");
            familiarReceptacle.m_41784_().m_128365_("dead_pet", (Tag)deadPetTag);
            return familiarReceptacle;
        }, () -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 20);
        TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42500_, 10), () -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42583_, 10), () -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42403_, 3), () -> new ItemStack((ItemLike)ModItems.dust_of_vanishing), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42452_, 3), () -> new ItemStack((ItemLike)ModItems.dust_of_frost), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_151058_), () -> new ItemStack((ItemLike)ModItems.grave_dust, 3), 1, 3), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42363_), () -> EffectHelper.createFrostbiteArrows(0, 8), 5, 1), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42648_), () -> new ItemStack((ItemLike)ModItems.seeker_rod), 1, 1)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)(Helper.RANDOM.nextBoolean() ? ModBlocks.white_marble_stairs : ModBlocks.dark_marble_stairs), 20), () -> new ItemStack((ItemLike)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.impregnated_diamond.withRandomImpregnation(new ItemStack((ItemLike)ModItems.impregnated_diamond)), () -> new ItemStack((ItemLike)ModItems.grave_dust, 12), 1, 5), new TradeForItems(() -> ModItems.impregnated_diamond.withRandomImpregnation(new ItemStack((ItemLike)ModItems.impregnated_diamond)), () -> new ItemStack((ItemLike)ModItems.grave_dust, 12), 1, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42679_), () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((ItemLike)Items.f_42436_)), 3, 5), new TradeForItems(() -> new ItemStack((ItemLike)ModItems.enchanted_bundle), () -> new ItemStack((ItemLike)ModItems.grave_dust, 6), 1, 5)}, (Object)3, (Object)itemListingArray));
        VillagerTrades.ItemListing[] itemListingArray2 = new VillagerTrades.ItemListing[5];
        itemListingArray2[0] = new TradeForItems(ModItems.lollipop::getRandom, () -> new ItemStack((ItemLike)ModItems.grave_dust), 5, 1);
        itemListingArray2[1] = new TradeForItems(ModItems.lollipop::getRandom, () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((ItemLike)Items.f_42735_)), 3, 1);
        itemListingArray2[2] = new TradeForItems(ModItems.lollipop::getRandom, () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((ItemLike)Items.f_42436_)), 3, 1);
        itemListingArray2[3] = new TradeForItems(ModItems.lollipop::getRandom, () -> ModItems.scroll_of_knowledge.createWithXp(100), 5, 1);
        itemListingArray2[4] = new TradeForItems(ModItems.lollipop::getRandom, () -> EffectHelper.createFrostbiteArrows(0, 8), 5, 1);
        HALLOWEEN_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)itemListingArray2, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> ModItems.lollipop.getRandom(5), () -> new ItemStack((ItemLike)ModItems.lost_tablet), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandom(10), () -> ModItems.voodoo_poppet.createWithRandomProtections(3), 1, 5), new TradeForItems(() -> ModItems.lollipop.getRandom(3), () -> EffectHelper.createFrostbiteArrows(2, 8), 5, 3), new TradeForItems(() -> ModItems.lollipop.getRandom(10), () -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.frostbite, 1)), 1, 5)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> ModItems.lollipop.getRandom(64), () -> new ItemStack((ItemLike)ModItems.essence_of_undeath), 1, 15), new TradeForItems(() -> ModItems.lollipop.getRandom(20), () -> ModItems.voodoo_poppet.createWithRandomProtections(6), 1, 10), new TradeForItems(() -> ModItems.lollipop.getRandom(5), () -> EffectHelper.createFrostbiteArrows(4, 8), 5, 5)}));
        VillagerTrades.ItemListing[] itemListingArray3 = new VillagerTrades.ItemListing[3];
        itemListingArray3[0] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42516_, 10), ModItems.lollipop::getRandom, 5, 1);
        itemListingArray3[1] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_41911_, 10), ModItems.lollipop::getRandom, 5, 1);
        itemListingArray3[2] = new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42413_, 10), ModItems.lollipop::getRandom, 5, 1);
        CHRISTMAS_TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)itemListingArray3, (Object)2, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.f_151058_), () -> ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().orElse(new ItemStack((ItemLike)Items.f_42436_)), 5, 3), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_151058_, 10), () -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.frostbite, 3)), 1, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_42516_), () -> new ItemStack((ItemLike)Items.f_42532_), () -> new ItemStack((ItemLike)ModItems.villager_gift), 1, 0)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new TradeForItems(() -> new ItemStack((ItemLike)Items.f_41960_, 30), () -> new ItemStack((ItemLike)ModItems.soul_receptacle), 1, 5), new TradeForItems(() -> new ItemStack((ItemLike)Items.f_41960_, 64), () -> EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)ModEnchantments.frostbite, 5)), 1, 10), new TradeForItems(() -> new ItemStack((ItemLike)ModItems.essence_of_undeath), () -> new ItemStack((ItemLike)ModItems.christmas_hat), 1, 10)}));
    }

    private static enum TradeType {
        COMMON,
        UNCOMMON,
        RARE;


        @Nullable
        private VillagerTrades.ItemListing[] getBasicTrades() {
            return (VillagerTrades.ItemListing[])TRADES.get(this.ordinal() + 1);
        }

        @Nullable
        private VillagerTrades.ItemListing[] getHalloweenTrades() {
            return (VillagerTrades.ItemListing[])HALLOWEEN_TRADES.get(this.ordinal() + 1);
        }

        @Nullable
        private VillagerTrades.ItemListing[] getChristmasTrades() {
            return (VillagerTrades.ItemListing[])CHRISTMAS_TRADES.get(this.ordinal() + 1);
        }
    }

    private static class TradeForItems
    implements VillagerTrades.ItemListing {
        private final Supplier<ItemStack> requestItem1;
        private final Supplier<ItemStack> requestItem2;
        private final Supplier<ItemStack> rewardItem;
        private final int maxUses;
        private final int villagerXp;

        private TradeForItems(Supplier<ItemStack> requestItem, Supplier<ItemStack> rewardItem, int maxUses, int villagerXp) {
            this(requestItem, () -> ItemStack.f_41583_, rewardItem, maxUses, villagerXp);
        }

        private TradeForItems(Supplier<ItemStack> requestItem1, Supplier<ItemStack> requestItem2, Supplier<ItemStack> rewardItem, int maxUses, int villagerXp) {
            this.requestItem1 = requestItem1;
            this.requestItem2 = requestItem2;
            this.rewardItem = rewardItem;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
        }

        public MerchantOffer m_5670_(Entity entity, Random random) {
            return new MerchantOffer(this.requestItem1.get(), this.requestItem2.get(), this.rewardItem.get(), 0, this.maxUses, this.villagerXp, 0.0f, 0);
        }
    }
}

