/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.GuiConfig;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.StyleType;

@OnlyIn(value=Dist.CLIENT)
public class CustomOptionsRowList
extends ContainerObjectSelectionList<Row>
implements GuiConfig.IHideable {
    public CustomOptionsRowList(int x, int y, int width, int height, int widgetHeight, Option ... options) {
        super(Minecraft.m_91087_(), width, height, y + height, y, widgetHeight);
        this.f_93393_ = x;
        this.f_93392_ = x + width;
        this.f_93390_ = y;
        this.f_93391_ = y + height;
        this.f_93394_ = false;
        this.m_93473_(false, 0);
        this.m_93488_(false);
        this.m_93496_(false);
        for (Option option : options) {
            this.m_7085_((AbstractSelectionList.Entry)Row.create(this.f_93386_.f_91066_, Minecraft.m_91087_().m_91268_().m_85445_(), option));
        }
    }

    public int m_5759_() {
        return 190;
    }

    protected void m_93451_(PoseStack poseStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.m_5773_() > 0) {
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            super.m_93451_(poseStack, this.m_5747_(), this.f_93390_ + 4 - (int)this.m_93517_(), mouseX, mouseY, partialTicks);
        }
    }

    protected int m_5756_() {
        return Minecraft.m_91087_().m_91268_().m_85445_() / 2 + (int)((double)this.f_93388_ / 2.01);
    }

    @Override
    public void show() {
        for (Row row : this.m_6702_()) {
            for (AbstractWidget widget : row.widgets) {
                if (widget == null) continue;
                widget.f_93624_ = true;
                widget.f_93623_ = true;
            }
        }
    }

    @Override
    public void hide() {
        for (Row row : this.m_6702_()) {
            for (AbstractWidget widget : row.widgets) {
                if (widget == null) continue;
                widget.f_93624_ = false;
                widget.f_93623_ = false;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Row
    extends ContainerObjectSelectionList.Entry<Row> {
        private final List<AbstractWidget> widgets;

        private Row(List<AbstractWidget> widgetsIn) {
            this.widgets = widgetsIn;
        }

        public static Row create(Options settings, int guiWidth, Option option) {
            return new Row((List<AbstractWidget>)ImmutableList.of((Object)option.m_7496_(settings, guiWidth / 2 - 95, 0, 190)));
        }

        public void m_6311_(PoseStack poseStack, int x, int y, int p_230432_4_, int p_230432_5_, int p_230432_6_, int mouseX, int mouseY, boolean isHover, float partialTicks) {
            this.widgets.forEach(widget -> {
                widget.f_93621_ = y;
                widget.setHeight(14);
                boolean isHovered = mouseX >= widget.f_93620_ && mouseY >= widget.f_93621_ && mouseX < widget.f_93620_ + widget.m_5711_() && mouseY < widget.f_93621_ + widget.m_93694_();
                Helper.fillGradient(poseStack.m_85850_().m_85861_(), widget.f_93620_ + 1, widget.f_93621_ + 1, widget.f_93620_ + widget.m_5711_() - 2, widget.f_93621_ + widget.m_93694_() - 2, isHovered ? -14668449 : 0x70000000, isHovered ? -14668449 : 0x30000000, -50, true);
                float alpha = 1.0f;
                GuiComponent.m_93208_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (String)Helper.capitalizeWord(widget.m_6035_().getString()), (int)(widget.f_93620_ + widget.m_5711_() / 2), (int)(widget.f_93621_ + (widget.m_93694_() - 8) / 2), (int)((widget.f_93623_ ? (isHovered ? -1875 : -1) : 0) | Mth.m_14167_((float)(alpha * 255.0f)) << 24));
                if (isHovered) {
                    Minecraft mc = Minecraft.m_91087_();
                    MutableComponent info = new TranslatableComponent("tombstone.config." + widget.m_6035_().getString().split(":")[0] + ".tooltip").m_6270_(StyleType.TOOLTIP_DESC);
                    int start = widget.f_93620_ + widget.m_5711_();
                    this.drawInBox(poseStack, Collections.singletonList(new TextComponent(info.getString())), start, widget.f_93621_ + widget.m_93694_() / 2, Minecraft.m_91087_().m_91268_().m_85445_() - start - 2, mc.f_91062_);
                }
            });
        }

        private void drawInBox(PoseStack poseStack, List<Component> list, int x, int y, int boxWidth, Font font) {
            ArrayList toDisplay = new ArrayList();
            for (Component content : list) {
                toDisplay.addAll(font.m_92923_((FormattedText)content, boxWidth));
            }
            Objects.requireNonNull(font);
            int boxHeight = 9 * toDisplay.size() + 2;
            int startY = y - boxHeight / 2;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(startY - 1), (int)(x + boxWidth + 1), (int)(startY + boxHeight + 1), (int)-14668449);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)startY, (int)(x + boxWidth), (int)(startY + boxHeight), (int)Integer.MIN_VALUE);
            for (int i = 0; i < toDisplay.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)toDisplay.get(i);
                Objects.requireNonNull(font);
                GuiComponent.m_168756_((PoseStack)poseStack, (Font)font, (FormattedCharSequence)formattedCharSequence, (int)(x + 2), (int)(startY + 2 + i * 9), (int)-1875);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }
}

