/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.CompatibilityEnigmatic;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.PlayerPreference;

public final class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.m_122779_());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean autoequip(ItemStack stack, Player player) {
        boolean bl;
        if (stack.m_41619_()) return false;
        if (stack.m_41741_() != 1) return false;
        if (CompatibilityEnigmatic.instance.isDenied(stack)) return false;
        if (InventoryHelper.isPowerSuit(stack)) {
            return false;
        }
        if (EnchantHelper.getEnchantmentLevel(Enchantments.f_44975_, stack) > 0) {
            return false;
        }
        if (((Boolean)ConfigTombstone.compatibility.curioAutoEquip.get()).booleanValue() && SupportMods.CURIOS.isLoaded() && CompatibilityCurio.instance.autoEquip(stack, player)) {
            return true;
        }
        if (player.m_21206_().m_41619_() && (stack.m_41720_().canPerformAction(stack, ToolActions.SHIELD_BLOCK) || InventoryHelper.isBattleSign(stack))) {
            player.m_8061_(EquipmentSlot.OFFHAND, stack.m_41777_());
            return true;
        }
        EquipmentSlot slot = stack.m_41720_().getEquipmentSlot(stack);
        boolean isElytra = false;
        if (slot == null) {
            Item item = stack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                slot = armorItem.m_40402_();
            } else {
                if (!InventoryHelper.isElytra(stack)) return false;
                slot = EquipmentSlot.CHEST;
                isElytra = true;
            }
        } else if (slot == EquipmentSlot.CHEST) {
            isElytra = stack.m_41720_() instanceof ElytraItem;
        }
        int slotId = slot.m_20749_();
        ItemStack stackInSlot = (ItemStack)player.m_150109_().f_35975_.get(slotId);
        if (stackInSlot.m_41619_()) {
            player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
            return true;
        }
        if (slot != EquipmentSlot.CHEST) {
            return false;
        }
        boolean equipElytraInPriority = PlayerPreference.get(player.m_142081_()).equipElytraInPriority();
        if (InventoryHelper.isElytra(stackInSlot)) {
            if (isElytra) return false;
            if (equipElytraInPriority) return false;
            bl = true;
        } else {
            if (!isElytra) return false;
            if (!equipElytraInPriority) return false;
            bl = true;
        }
        boolean canEquip = bl;
        if (!canEquip) return false;
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackInSlot.m_41777_());
        player.m_150109_().f_35975_.set(slotId, (Object)stack.m_41777_());
        return true;
    }

    public static ItemStack findItemInMainInventory(Player player, Predicate<ItemStack> predic) {
        return player.m_150109_().f_35974_.stream().filter(predic).findFirst().orElse(ItemStack.f_41583_);
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.m_41720_() instanceof ElytraItem || InventoryHelper.isWing(stack);
    }

    private static boolean isWing(ItemStack stack) {
        return SupportMods.WINGS.isLoaded() && Optional.ofNullable(stack.m_41720_().getRegistryName()).map(rl -> SupportMods.WINGS.m_7912_().equals(rl.m_135827_()) && rl.m_135815_().endsWith("_wings")).orElse(false) != false;
    }

    public static boolean isTool(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41741_() == 1 && (stack.m_41720_() instanceof TieredItem || stack.m_41720_() instanceof FishingRodItem || stack.m_41720_() instanceof ShearsItem);
    }

    private static boolean isPowerSuit(ItemStack stack) {
        return SupportMods.POWERSUITS.isLoaded() && Optional.ofNullable(stack.m_41720_().getRegistryName()).map(rl -> "powersuits".equals(rl.m_135827_())).orElse(false) != false;
    }

    private static boolean isBattleSign(ItemStack stack) {
        return SupportMods.TCONSTRUCT.isLoaded() && Optional.ofNullable(stack.m_41720_().getRegistryName()).map(rl -> "tconstruct".equals(rl.m_135827_()) && "battlesign".equals(rl.m_135815_())).orElse(false) != false;
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.m_150930_(item));
    }

    public static ItemStack findFirstInInventory(@Nullable Player player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public static boolean removeFirstInInventory(Player player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (!itemHandler.getStackInSlot(i).m_41619_() || ++found < count) continue;
            return true;
        }
        return false;
    }
}

