/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EnchantHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemBook {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
        this.withDefaultInfo();
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        ItemStack offhand;
        if (stack.m_41720_() != this || (offhand = player.m_21206_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        if (offhand.m_150930_(Items.f_42690_)) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText(Items.f_42690_.m_41466_()));
        }
        boolean isTetraModular = SupportMods.TETRA.isLoaded() && Optional.ofNullable(offhand.m_41720_().getRegistryName()).map(r -> r.m_135827_().equals(SupportMods.TETRA.m_7912_()) && r.m_135815_().startsWith("modular_")).orElse(false) != false;
        Map<Enchantment, Integer> enchantments = EnchantHelper.getEnchantments(offhand);
        if (enchantments.size() == 0) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_NO_ENCHANTMENT.getText(new Object[0]));
        }
        Iterator<Map.Entry<Enchantment, Integer>> it = enchantments.entrySet().iterator();
        stack.m_41774_(1);
        int enchantMax = isTetraModular ? Integer.MAX_VALUE : EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.disenchanter) + 1;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry<Enchantment, Integer> entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(entry.getKey(), entry.getValue());
            EnchantmentHelper.m_44865_(map, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        int left = enchantments.size();
        if (left == 0) {
            if (offhand.m_41788_()) {
                offhand.m_41742_(1);
            } else {
                offhand.m_41749_("RepairCost");
            }
        }
        if (isTetraModular) {
            CompoundTag tag = offhand.m_41784_();
            tag.m_128473_("Enchantments");
            tag.m_128473_("StoredEnchantments");
            tag.m_128473_("EnchantmentMapping");
            tag.m_128359_("id", UUID.randomUUID().toString());
        }
        EnchantmentHelper.m_44865_(enchantments, (ItemStack)offhand);
        ModTriggers.USE_DISENCHANTMENT.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)(left == 0 ? LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]) : LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(left)), 1);
    }
}

