/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFishingRodOfMisadventure
extends FishingRodItem
implements ISoulConsumer,
IDelayedNBTLoot {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        super(new Item.Properties().m_41491_(ModTabs.mainTab).m_41499_(32).m_41486_());
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int speed;
        boolean isEnchanted = this.isEnchanted(stack);
        boolean isAncient = this.isAncient(stack);
        if (Helper.canShowTooltip(level)) {
            tooltip.add((Component)new TranslatableComponent(this.m_5671_(stack) + ".desc" + (isEnchanted ? 2 : 1)).m_6270_(StyleType.TOOLTIP_DESC));
            tooltip.add((Component)new TranslatableComponent(this.m_5671_(stack) + ".use" + (isEnchanted ? 2 : 1)).m_6270_(StyleType.TOOLTIP_USE));
        } else {
            tooltip.add((Component)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("enchantment.tombstone.fishing_bad_luck").m_130946_(" ").m_130946_(isAncient ? "X" : (isEnchanted ? "V" : "I")).m_6881_().m_130940_(ChatFormatting.GRAY));
        int n = isAncient ? 5 : (speed = isEnchanted ? 2 : 0);
        if (speed > 0) {
            tooltip.add(Enchantments.f_44954_.m_44700_(speed));
        }
        if (isAncient) {
            tooltip.add(ModEnchantments.soulbound.m_44700_(1));
        }
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_41389_(tab)) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack enchantedStack = NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "enchant", true);
            items.add((Object)enchantedStack);
            items.add((Object)NBTStackHelper.setBoolean(enchantedStack.m_41777_(), "ancient", true));
        }
    }

    public Component m_7626_(ItemStack stack) {
        Component name = super.m_7626_(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.m_6879_())).m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "ancient");
    }

    public String getSimpleName() {
        return this.name;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean isEnchanted = this.isEnchanted(stack);
        if (player.f_36083_ != null) {
            if (!level.m_5776_()) {
                int damage = player.f_36083_.m_37156_(stack);
                if (!isEnchanted) {
                    Helper.damageItem(stack, damage, (ServerPlayer)player, hand);
                }
            }
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11939_, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.f_46441_.nextFloat() * 0.4f + 0.8f));
            level.m_151545_((Entity)player, GameEvent.f_157814_, (Entity)player);
        } else {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11941_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.f_46441_.nextFloat() * 0.4f + 0.8f));
            if (!level.m_5776_()) {
                boolean isAncient = this.isAncient(stack);
                FishingHook fishingHook = new FishingHook(player, level, 0, isAncient ? 5 : (isEnchanted ? 2 : 0));
                fishingHook.f_37096_ = -(isAncient ? 100 : (isEnchanted ? 50 : 10));
                level.m_7967_((Entity)fishingHook);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_151545_((Entity)player, GameEvent.f_157813_, (Entity)player);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int m_6473_() {
        return 0;
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.isEnchanted(stack) && super.m_142522_(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (!this.isEnchanted(stack)) {
            super.setDamage(stack, damage);
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            stack.m_41721_(0);
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_FISHING_ROD.trigger(player);
                return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 2);
            }
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    public String m_5524_() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new TBSoulConsumerProvider(this);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return NBTStackHelper.setBoolean(NBTStackHelper.setBoolean(stack, "enchant", true), "ancient", true);
    }
}

